/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.config;

import io.neonbee.config.AuthHandlerConfig;
import io.neonbee.config.EndpointConfig;
import io.neonbee.config.ServerConfig;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class ServerConfigConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, ServerConfig obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "authChainConfig": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<AuthHandlerConfig> list = new ArrayList<AuthHandlerConfig>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new AuthHandlerConfig((JsonObject)item));
                        }
                    });
                    obj.setAuthChainConfig(list);
                    break;
                }
                case "correlationStrategy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCorrelationStrategy(ServerConfig.CorrelationStrategy.valueOf((String)member.getValue()));
                    break;
                }
                case "endpointConfigs": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<AuthHandlerConfig> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add((AuthHandlerConfig)((Object)new EndpointConfig((JsonObject)item)));
                        }
                    });
                    obj.setEndpointConfigs(list);
                    break;
                }
                case "errorHandlerClassName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setErrorHandlerClassName((String)member.getValue());
                    break;
                }
                case "errorHandlerTemplate": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setErrorHandlerTemplate((String)member.getValue());
                    break;
                }
                case "handlerFactoriesClassNames": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<AuthHandlerConfig> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((AuthHandlerConfig)((Object)((String)item)));
                        }
                    });
                    obj.setHandlerFactoriesClassNames(list);
                    break;
                }
                case "sessionCookieName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSessionCookieName((String)member.getValue());
                    break;
                }
                case "sessionHandling": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSessionHandling(ServerConfig.SessionHandling.valueOf((String)member.getValue()));
                    break;
                }
                case "timeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "timeoutStatusCode": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setTimeoutStatusCode(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(ServerConfig obj, JsonObject json) {
        ServerConfigConverter.toJson(obj, json.getMap());
    }

    static void toJson(ServerConfig obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getAuthChainConfig() != null) {
            array = new JsonArray();
            obj.getAuthChainConfig().forEach(item -> array.add((Object)item.toJson()));
            json.put("authChainConfig", array);
        }
        if (obj.getCorrelationStrategy() != null) {
            json.put("correlationStrategy", obj.getCorrelationStrategy().name());
        }
        if (obj.getEndpointConfigs() != null) {
            array = new JsonArray();
            obj.getEndpointConfigs().forEach(item -> array.add((Object)item.toJson()));
            json.put("endpointConfigs", array);
        }
        if (obj.getErrorHandlerClassName() != null) {
            json.put("errorHandlerClassName", obj.getErrorHandlerClassName());
        }
        if (obj.getErrorHandlerTemplate() != null) {
            json.put("errorHandlerTemplate", obj.getErrorHandlerTemplate());
        }
        if (obj.getHandlerFactoriesClassNames() != null) {
            array = new JsonArray();
            obj.getHandlerFactoriesClassNames().forEach(item -> array.add(item));
            json.put("handlerFactoriesClassNames", array);
        }
        if (obj.getSessionCookieName() != null) {
            json.put("sessionCookieName", obj.getSessionCookieName());
        }
        if (obj.getSessionHandling() != null) {
            json.put("sessionHandling", obj.getSessionHandling().name());
        }
        json.put("timeout", obj.getTimeout());
        json.put("timeoutStatusCode", obj.getTimeoutStatusCode());
    }
}

