/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data;

import io.neonbee.data.DataContext;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataSink;
import io.neonbee.data.DataSource;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Future;

public interface DataAdapter<T>
extends DataSource<T>,
DataSink<T> {
    @Override
    default public Future<T> retrieveData(DataQuery query, DataContext context) {
        LoggingFacade.create(this.getClass()).correlateWith(context).warn("{} does not implement retrieveData", this.getClass().getSimpleName());
        return Future.failedFuture((Throwable)new UnsupportedOperationException("retrieveData not implemented"));
    }

    @Override
    default public Future<T> manipulateData(DataQuery query, DataContext context) {
        switch (query.getAction()) {
            case CREATE: {
                return this.createData(query, context);
            }
            case UPDATE: {
                return this.updateData(query, context);
            }
            case DELETE: {
                return this.deleteData(query, context);
            }
        }
        return Future.failedFuture((Throwable)new IllegalArgumentException("manipulateData is unable to handle this action"));
    }

    default public Future<T> createData(DataQuery query, DataContext context) {
        LoggingFacade.create(this.getClass()).correlateWith(context).warn("{} does neither implement manipulateData, nor createData", this.getClass().getSimpleName());
        return Future.failedFuture((Throwable)new UnsupportedOperationException("manipulateData / createData not implemented"));
    }

    default public Future<T> updateData(DataQuery query, DataContext context) {
        LoggingFacade.create(this.getClass()).correlateWith(context).warn("{} does neither implement manipulateData, nor alterData", this.getClass().getSimpleName());
        return Future.failedFuture((Throwable)new UnsupportedOperationException("manipulateData / alterData not implemented"));
    }

    default public Future<T> deleteData(DataQuery query, DataContext context) {
        LoggingFacade.create(this.getClass()).correlateWith(context).warn("{} does neither implement manipulateData, nor deleteData", this.getClass().getSimpleName());
        return Future.failedFuture((Throwable)new UnsupportedOperationException("manipulateData / deleteData not implemented"));
    }
}

