/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DataException
extends RuntimeException {
    public static final int FAILURE_CODE_UNKNOWN_STRATEGY = 1000;
    public static final int FAILURE_CODE_MISSING_MESSAGE_CODEC = 1001;
    public static final int FAILURE_CODE_NO_HANDLERS = 1010;
    public static final int FAILURE_CODE_TIMEOUT = 1020;
    public static final int FAILURE_CODE_PROCESSING_FAILED = 1030;
    private static final long serialVersionUID = 1L;
    private final int failureCode;
    private final Map<String, Object> failureDetail;

    public DataException() {
        this((String)null);
    }

    public DataException(String message) {
        this(-1, message);
    }

    public DataException(int failureCode) {
        this(failureCode, null);
    }

    public DataException(int failureCode, String message) {
        this(failureCode, message, Map.of());
    }

    public DataException(int failureCode, String message, Map<String, Object> failureDetail) {
        super(message);
        this.failureCode = failureCode;
        this.failureDetail = Objects.requireNonNull(failureDetail);
    }

    public int failureCode() {
        return this.failureCode;
    }

    public Map<String, Object> failureDetail() {
        return Collections.unmodifiableMap(this.failureDetail);
    }

    public int hashCode() {
        return Objects.hash(this.failureCode, this.getMessage(), this.failureDetail);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataException)) {
            return false;
        }
        DataException other = (DataException)obj;
        return this.failureCode == other.failureCode && Optional.ofNullable(this.getMessage()).orElse("").equals(Optional.ofNullable(other.getMessage()).orElse("")) && this.failureDetail().equals(other.failureDetail());
    }

    @Override
    public String toString() {
        return "(" + this.failureCode + ")" + Optional.ofNullable(this.getMessage()).map(msg -> " " + msg).orElse("");
    }
}

