/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.neonbee.data.DataAction;
import io.neonbee.internal.codec.BufferDeserializer;
import io.neonbee.internal.codec.BufferSerializer;
import io.neonbee.internal.helper.CollectionHelper;
import io.vertx.core.buffer.Buffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DataQuery {
    private static final Pattern QUERY_SPLIT_PATTERN = Pattern.compile("&");
    private static final Pattern PARAM_SPLIT_PATTERN = Pattern.compile("=");
    private static final int MAX_CONTENT_LENGTH_TO_STRING = 100;
    @JsonProperty
    @VisibleForTesting
    DataAction action = DataAction.READ;
    @JsonProperty
    @VisibleForTesting
    String uriPath;
    @JsonProperty
    @VisibleForTesting
    Map<String, List<String>> parameters;
    @JsonProperty
    @VisibleForTesting
    Map<String, List<String>> headers;
    @JsonSerialize(using=BufferSerializer.class)
    @JsonDeserialize(using=BufferDeserializer.class)
    @JsonProperty
    @VisibleForTesting
    Buffer body;

    public DataQuery() {
        this(DataAction.READ);
    }

    public DataQuery(DataAction action) {
        this(action, (String)null);
    }

    public DataQuery(DataAction action, Buffer body) {
        this(action, null, body);
    }

    public DataQuery(String uriPath) {
        this(DataAction.READ, uriPath);
    }

    public DataQuery(DataAction action, String uriPath) {
        this(action, uriPath, (Buffer)null);
    }

    public DataQuery(DataAction action, String uriPath, Buffer body) {
        this(action, uriPath, null, body);
    }

    public DataQuery(String uriPath, String query) {
        this(DataAction.READ, uriPath, query);
    }

    public DataQuery(DataAction action, String uriPath, String query) {
        this(action, uriPath, query, (Buffer)null);
    }

    public DataQuery(DataAction action, String uriPath, String query, Buffer body) {
        this(action, uriPath, query, null, body);
    }

    public DataQuery(String uriPath, String query, Map<String, List<String>> headers) {
        this(DataAction.READ, uriPath, query, headers);
    }

    public DataQuery(DataAction action, String uriPath, String query, Map<String, List<String>> headers) {
        this(action, uriPath, query, headers, null);
    }

    public DataQuery(DataAction action, String uriPath, String query, Map<String, List<String>> headers, Buffer body) {
        this.action = action;
        this.setUriPath(uriPath);
        this.headers = CollectionHelper.mutableCopyOf(headers != null ? headers : Map.of());
        this.parameters = DataQuery.parseQueryString(query);
        this.body = CollectionHelper.copyOf(body);
    }

    public DataAction getAction() {
        return this.action;
    }

    public DataQuery setAction(DataAction action) {
        this.action = action;
        return this;
    }

    public String getUriPath() {
        return this.uriPath;
    }

    public DataQuery setUriPath(String uriPath) {
        if (!Strings.isNullOrEmpty((String)uriPath) && uriPath.contains("?")) {
            throw new IllegalArgumentException("uriPath must not contain a query");
        }
        this.uriPath = uriPath;
        return this;
    }

    public String getQuery() {
        Function<String, Stream> paramBuilder = name -> this.getParameterValues((String)name).stream().map(value -> String.format("%s=%s", name, value));
        return this.parameters.keySet().stream().flatMap(paramBuilder).collect(Collectors.joining("&"));
    }

    public DataQuery setQuery(String query) {
        this.parameters = DataQuery.parseQueryString(query);
        return this;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public List<String> getParameterValues(String name) {
        return this.getParameters().get(name);
    }

    public String getParameter(String name) {
        return this.getParameter(name, null);
    }

    public String getParameter(String name, String defaultValue) {
        return Optional.ofNullable(this.getParameterValues(name)).map(Collection::stream).flatMap(Stream::findFirst).orElse(defaultValue);
    }

    public DataQuery addParameter(String name, String ... values) {
        this.getParameters().computeIfAbsent(name, s -> new ArrayList()).addAll(Arrays.asList(values));
        return this;
    }

    public DataQuery setParameter(String name, String ... values) {
        this.removeParameter(name).addParameter(name, values);
        return this;
    }

    public DataQuery removeParameter(String name) {
        this.getParameters().remove(name);
        return this;
    }

    @VisibleForTesting
    static Map<String, List<String>> parseQueryString(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return new HashMap<String, List<String>>();
        }
        return QUERY_SPLIT_PATTERN.splitAsStream(query).map(paramString -> PARAM_SPLIT_PATTERN.split((CharSequence)paramString, 2)).map(paramArray -> Map.entry(paramArray[0], ((String[])paramArray).length > 1 ? paramArray[1] : "")).collect(Collectors.groupingBy(Map.Entry::getKey, HashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toCollection(ArrayList::new))));
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> getHeaderValues(String name) {
        return this.headers.get(name);
    }

    public String getHeader(String name) {
        return Optional.ofNullable(this.getHeaderValues(name)).map(Collection::stream).orElseGet(Stream::empty).findFirst().orElse(null);
    }

    public DataQuery setHeaders(Map<String, List<String>> headers) {
        this.headers = CollectionHelper.mutableCopyOf(headers);
        return this;
    }

    public DataQuery addHeader(String name, String value) {
        this.headers.computeIfAbsent(name, key -> new ArrayList()).add(value);
        return this;
    }

    public DataQuery setHeader(String name, String value) {
        this.headers.put(name, new ArrayList<String>(Collections.singleton(value)));
        return this;
    }

    public DataQuery removeHeader(String name) {
        this.headers.remove(name);
        return this;
    }

    public Buffer getBody() {
        return this.body;
    }

    public DataQuery setBody(Buffer body) {
        this.body = CollectionHelper.copyOf(body);
        return this;
    }

    public DataQuery copy() {
        return new DataQuery(this.action, this.uriPath, this.getQuery(), this.headers, this.body);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DataQuery)) {
            return false;
        }
        DataQuery dataQuery = (DataQuery)object;
        return Objects.equals((Object)this.action, (Object)dataQuery.action) && Objects.equals(this.uriPath, dataQuery.uriPath) && Objects.equals(this.parameters, dataQuery.parameters) && Objects.equals(this.headers, dataQuery.headers) && Objects.equals(this.body, dataQuery.body);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.uriPath, this.parameters, this.headers, this.body});
    }

    private String trimContent(String content) {
        if (Objects.isNull(content)) {
            return "";
        }
        if (content.length() <= 100) {
            return content;
        }
        return content.substring(0, 100) + "...";
    }

    public String toString() {
        return "DataQuery [action=" + (Object)((Object)this.action) + ", uriPath=" + this.uriPath + ", query=" + ", parameters=" + this.parameters + ", headers=" + this.headers.keySet().stream().map(key -> key + "=" + this.headers.get(key).stream().map(this::trimContent).collect(Collectors.toList())).collect(Collectors.joining(", ", "{", "}")) + ", body=" + this.body + ']';
    }
}

