/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data;

import io.neonbee.data.DataQuery;
import io.neonbee.data.DataSink;
import io.neonbee.data.DataSource;
import java.util.Objects;
import java.util.Optional;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class DataRequest {
    private DataSource<?> dataSource;
    private DataSink<?> dataSink;
    private String qualifiedName;
    private FullQualifiedName entityTypeName;
    private DataQuery query;
    private ResolutionStrategy resolutionStrategy;
    private long sendTimeout = -1L;
    private boolean localOnly;
    private boolean localPreferred = true;

    public DataRequest(DataSource<?> dataSource) {
        this(dataSource, new DataQuery());
    }

    public DataRequest(DataSource<?> dataSource, DataQuery query) {
        this.dataSource = Objects.requireNonNull(dataSource, "the data source cannot be null");
        this.query = Objects.requireNonNull(query, "the query cannot be null");
    }

    public <T> DataRequest(DataSink<T> dataSink, DataQuery query) {
        this.dataSink = Objects.requireNonNull(dataSink, "the data sink cannot be null");
        this.query = Objects.requireNonNull(query, "the query cannot be null");
    }

    public DataRequest(String qualifiedName) {
        this(qualifiedName, new DataQuery());
    }

    public DataRequest(String qualifiedName, DataQuery query) {
        this.qualifiedName = Objects.requireNonNull(qualifiedName, "the qualified name cannot be null");
        this.query = Objects.requireNonNull(query, "the query cannot be null");
    }

    public DataRequest(String entityTypeNamespace, String entityTypeName, DataQuery query) {
        this(new FullQualifiedName(entityTypeNamespace, entityTypeName), query);
    }

    public DataRequest(FullQualifiedName entityTypeName, DataQuery query) {
        this.entityTypeName = Objects.requireNonNull(entityTypeName, "the entity type name cannot be null");
        this.query = Objects.requireNonNull(query, "the query cannot be null");
    }

    public DataSource<?> getDataSource() {
        return this.dataSource;
    }

    public DataSink<?> getDataSink() {
        return this.dataSink;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public FullQualifiedName getEntityTypeName() {
        return this.entityTypeName;
    }

    public DataQuery getQuery() {
        return this.query;
    }

    public ResolutionStrategy getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public DataRequest setResolutionStrategy(ResolutionStrategy resolutionStrategy) {
        this.resolutionStrategy = resolutionStrategy;
        return this;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public DataRequest setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
        return this;
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public DataRequest setLocalOnly(boolean localOnly) {
        this.localOnly = localOnly;
        return this;
    }

    public boolean isLocalPreferred() {
        return this.localPreferred;
    }

    public DataRequest setLocalPreferred(boolean localPreferred) {
        this.localPreferred = localPreferred;
        return this;
    }

    public String toString() {
        return Optional.ofNullable(this.dataSource).map(Object::getClass).map(Class::getName).or(() -> Optional.ofNullable(this.qualifiedName)).or(() -> Optional.ofNullable(this.entityTypeName).map(Object::toString)).orElse("");
    }

    public static enum ResolutionStrategy {
        RECURSIVE,
        OPTIMIZED;

    }
}

