/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neonbee.data.DataContext;
import java.time.LocalTime;
import java.time.ZoneId;

public class DataVerticleCoordinateImpl
implements DataContext.DataVerticleCoordinate {
    private final String qualifiedName;
    private final String requestTimestamp;
    private String deploymentId;
    private String ipAddress;
    private String responseTimestamp;

    @JsonCreator
    DataVerticleCoordinateImpl(@JsonProperty(value="qualifiedName") String qualifiedName) {
        this.qualifiedName = qualifiedName;
        this.requestTimestamp = LocalTime.now(ZoneId.systemDefault()).toString();
    }

    @Override
    public String getRequestTimestamp() {
        return this.requestTimestamp;
    }

    @Override
    public String getResponseTimestamp() {
        return this.responseTimestamp;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    DataVerticleCoordinateImpl updateResponseTimestamp() {
        this.responseTimestamp = LocalTime.now(ZoneId.systemDefault()).toString();
        return this;
    }

    DataVerticleCoordinateImpl setDeploymentId(String instanceId) {
        this.deploymentId = instanceId;
        return this;
    }

    DataVerticleCoordinateImpl setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.requestTimestamp != null) {
            builder.append(this.requestTimestamp).append(' ');
        }
        builder.append(this.qualifiedName);
        if (this.deploymentId != null) {
            builder.append('[').append(this.deploymentId).append(']');
        }
        if (this.ipAddress != null) {
            builder.append('@').append(this.ipAddress);
        }
        if (this.responseTimestamp != null) {
            builder.append(' ').append(this.responseTimestamp);
        }
        return builder.toString();
    }
}

