/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data.internal.metrics;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.neonbee.NeonBee;
import io.neonbee.data.internal.metrics.DataVerticleMetrics;
import io.neonbee.data.internal.metrics.DataVerticleMetricsImpl;
import io.neonbee.data.internal.metrics.NoopDataVerticleMetrics;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.micrometer.backends.BackendRegistries;
import java.util.List;

public class ConfiguredDataVerticleMetrics
implements DataVerticleMetrics {
    public static final String ENABLED = "enabled";
    @Deprecated(forRemoval=true)
    public static final String METER_REGISTRY_NAME = "meterRegistryName";
    public static final String METRICS_REGISTRY_NAME = "metricsRegistryName";
    public static final String NUMBER_OF_REQUESTS = "reportNumberOfRequests";
    public static final String ACTIVE_REQUESTS = "reportActiveRequests";
    public static final String STATUS_COUNTER = "reportStatusCounter";
    public static final String TIMING = "reportTiming";
    @VisibleForTesting
    static final NoopDataVerticleMetrics DUMMY_IMPL = new NoopDataVerticleMetrics();
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    @VisibleForTesting
    final DataVerticleMetrics reportNumberOfRequests;
    @VisibleForTesting
    final DataVerticleMetrics reportActiveRequestsGauge;
    @VisibleForTesting
    final DataVerticleMetrics reportStatusCounter;
    @VisibleForTesting
    final DataVerticleMetrics reportTimingMetric;

    ConfiguredDataVerticleMetrics(DataVerticleMetrics reportNumberOfRequests, DataVerticleMetrics reportActiveRequestsGauge, DataVerticleMetrics reportStatusCounter, DataVerticleMetrics reportTimingMetric) {
        this.reportNumberOfRequests = reportNumberOfRequests;
        this.reportActiveRequestsGauge = reportActiveRequestsGauge;
        this.reportStatusCounter = reportStatusCounter;
        this.reportTimingMetric = reportTimingMetric;
    }

    public static DataVerticleMetrics configureMetricsReporting(NeonBee neonBee, JsonObject metricsConfig) {
        if (metricsConfig == null || !Boolean.TRUE.equals(metricsConfig.getBoolean(ENABLED))) {
            return DUMMY_IMPL;
        }
        String meterRegistryName = metricsConfig.getString(METRICS_REGISTRY_NAME, neonBee.getOptions().getMetricsRegistryName());
        MeterRegistry registry = BackendRegistries.getNow((String)meterRegistryName);
        if (registry == null) {
            LOGGER.error("Micrometer registry hasn't been registered yet or it has been stopped. Metrics will not be sent.");
            return DUMMY_IMPL;
        }
        DataVerticleMetricsImpl metricsImpl = new DataVerticleMetricsImpl(registry);
        return ConfiguredDataVerticleMetrics.configureDataVerticleMetrics(metricsConfig, metricsImpl);
    }

    private static DataVerticleMetrics configureDataVerticleMetrics(JsonObject metricsConfig, DataVerticleMetrics metricsImpl) {
        boolean activateAllMetrics;
        int fieldNameSize = metricsConfig.containsKey(METRICS_REGISTRY_NAME) ? 2 : 1;
        boolean bl = activateAllMetrics = metricsConfig.size() == fieldNameSize;
        if (activateAllMetrics) {
            return metricsImpl;
        }
        return new ConfiguredDataVerticleMetrics(Boolean.TRUE.equals(metricsConfig.getBoolean(NUMBER_OF_REQUESTS)) ? metricsImpl : DUMMY_IMPL, Boolean.TRUE.equals(metricsConfig.getBoolean(ACTIVE_REQUESTS)) ? metricsImpl : DUMMY_IMPL, Boolean.TRUE.equals(metricsConfig.getBoolean(STATUS_COUNTER)) ? metricsImpl : DUMMY_IMPL, Boolean.TRUE.equals(metricsConfig.getBoolean(TIMING)) ? metricsImpl : DUMMY_IMPL);
    }

    @Override
    public void reportNumberOfRequests(String name, String description, List<Tag> tags) {
        this.reportNumberOfRequests.reportNumberOfRequests(name, description, tags);
    }

    @Override
    public void reportActiveRequestsGauge(String name, String description, List<Tag> tags, Future<?> future) {
        this.reportActiveRequestsGauge.reportActiveRequestsGauge(name, description, tags, future);
    }

    @Override
    public void reportStatusCounter(String name, String description, Iterable<Tag> tags, Future<?> future) {
        this.reportStatusCounter.reportStatusCounter(name, description, tags, future);
    }

    @Override
    public void reportTimingMetric(String name, String description, Iterable<Tag> tags, Future<?> future) {
        this.reportTimingMetric.reportTimingMetric(name, description, tags, future);
    }
}

