/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data.internal.metrics;

import com.google.common.collect.Iterables;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.neonbee.data.internal.metrics.DataVerticleMetrics;
import io.vertx.core.Future;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class DataVerticleMetricsImpl
implements DataVerticleMetrics {
    private static final ImmutableTag SUCCEEDED_TAG = new ImmutableTag("succeeded", "true");
    private static final ImmutableTag FAILED_TAG = new ImmutableTag("succeeded", "false");
    private final Map<Meter.Id, LongAdder> activeRequestsMap = new ConcurrentHashMap<Meter.Id, LongAdder>();
    private final MeterRegistry registry;

    DataVerticleMetricsImpl(MeterRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void reportNumberOfRequests(String name, String description, List<Tag> tags) {
        Counter.builder((String)name).description(description).tags(tags).register(this.registry).increment();
    }

    @Override
    public void reportActiveRequestsGauge(String name, String description, List<Tag> tags, Future<?> future) {
        LongAdder longAdder = this.getGaugeLongAdder(name, description, tags, this.registry);
        longAdder.increment();
        future.onComplete(event -> longAdder.decrement());
    }

    private LongAdder getGaugeLongAdder(String name, String description, List<Tag> tags, MeterRegistry registry) {
        LongAdder longAdder = new LongAdder();
        Gauge gauge = Gauge.builder((String)name, (Object)longAdder, LongAdder::doubleValue).description(description).tags(tags).register(registry);
        this.activeRequestsMap.computeIfAbsent(gauge.getId(), id -> longAdder);
        return longAdder;
    }

    @Override
    public void reportStatusCounter(String name, String description, Iterable<Tag> tags, Future<?> future) {
        future.onComplete(data -> Counter.builder((String)name).description("succeeded response count").tags(Iterables.concat((Iterable)tags, List.of(data.succeeded() ? SUCCEEDED_TAG : FAILED_TAG))).register(this.registry).increment());
    }

    @Override
    public void reportTimingMetric(String name, String description, Iterable<Tag> tags, Future<?> future) {
        long start = System.nanoTime();
        future.onComplete(data -> this.reportTimeMetric(name, description, tags, start));
    }

    private void reportTimeMetric(String name, String description, Iterable<Tag> tags, long start) {
        long time = System.nanoTime() - start;
        Timer timer = Timer.builder((String)name).description(description).tags(tags).register(this.registry);
        timer.record(time, TimeUnit.NANOSECONDS);
    }
}

