/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint;

import com.google.common.base.Strings;
import io.neonbee.config.AuthHandlerConfig;
import io.neonbee.config.EndpointConfig;
import io.neonbee.endpoint.Endpoint;
import io.neonbee.internal.handler.ChainAuthHandler;
import io.neonbee.internal.handler.HooksHandler;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;

public final class MountableEndpoint {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private final EndpointConfig endpointConfig;
    private final Endpoint endpoint;
    private final Router endpointRouter;

    public static Future<MountableEndpoint> create(Vertx vertx, EndpointConfig endpointConfig) {
        String endpointType = endpointConfig.getType();
        if (Strings.isNullOrEmpty((String)endpointType)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Endpoint with configuration {} is missing the 'type' field", endpointConfig.toJson().encode());
            }
            return Future.failedFuture((Throwable)new IllegalArgumentException("Endpoint is missing the 'type' field"));
        }
        return AsyncHelper.executeBlocking(vertx, () -> MountableEndpoint.loadClass(endpointType)).compose(endpoint -> {
            JsonObject endpointAdditionalConfig = Optional.ofNullable(endpoint.getDefaultConfig().getAdditionalConfig()).map(JsonObject::copy).orElseGet(JsonObject::new);
            Optional.ofNullable(endpointConfig.getAdditionalConfig()).ifPresent(arg_0 -> ((JsonObject)endpointAdditionalConfig).mergeIn(arg_0));
            try {
                String endpointBasePath = MountableEndpoint.getEndpointBasePath(endpointConfig, endpoint);
                return endpoint.createEndpointRouter(vertx, endpointBasePath, endpointAdditionalConfig).map(endpointRouter -> new MountableEndpoint(endpointConfig, (Endpoint)endpoint, (Router)endpointRouter));
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize endpoint router for endpoint with type {} with configuration {}", new Object[]{endpointType, endpointAdditionalConfig, e});
                return Future.failedFuture((Throwable)e);
            }
        });
    }

    private MountableEndpoint(EndpointConfig endpointConfig, Endpoint endpoint, Router endpointRouter) {
        this.endpointConfig = endpointConfig;
        this.endpoint = endpoint;
        this.endpointRouter = endpointRouter;
    }

    public void mount(Vertx vertx, Router rootRouter, Optional<ChainAuthHandler> defaultAuthHandler) {
        String endpointBasePath = MountableEndpoint.getEndpointBasePath(this.endpointConfig, this.endpoint);
        Route endpointRoute = rootRouter.route(endpointBasePath + "*");
        Optional<List<AuthHandlerConfig>> effectiveAuthChainConfig = Optional.ofNullable(this.endpointConfig.getAuthChainConfig()).or(() -> Optional.ofNullable(this.endpoint.getDefaultConfig().getAuthChainConfig()));
        effectiveAuthChainConfig.map(authChainConfig -> ChainAuthHandler.create(vertx, authChainConfig)).or(() -> defaultAuthHandler).ifPresent(arg_0 -> ((Route)endpointRoute).handler(arg_0));
        endpointRoute.handler((Handler)new HooksHandler());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Mounting endpoint with type {} and configuration {}to base path {} using {} authentication handler", new Object[]{this.endpointConfig.getType(), this.endpointConfig, endpointBasePath, effectiveAuthChainConfig.map(authenticationHandler -> "an").orElse("no")});
        }
        endpointRoute.subRouter(this.endpointRouter);
    }

    private static String getEndpointBasePath(EndpointConfig endpointConfig, Endpoint endpoint) {
        Object endpointBasePath = Optional.ofNullable(endpointConfig.getBasePath()).orElse(endpoint.getDefaultConfig().getBasePath());
        if (!((String)endpointBasePath).endsWith("/")) {
            endpointBasePath = (String)endpointBasePath + "/";
        }
        return endpointBasePath;
    }

    private static Endpoint loadClass(String endpointType) throws Exception {
        try {
            return Class.forName(endpointType).asSubclass(Endpoint.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("No class for endpoint type {}", endpointType, e);
            throw new IllegalArgumentException("Endpoint class not found", e);
        }
        catch (ClassCastException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Endpoint type {} must implement {}", new Object[]{endpointType, Endpoint.class.getName(), e});
            }
            throw new IllegalArgumentException("Endpoint does not implement the Endpoint interface", e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Endpoint type {} must expose an empty constructor", endpointType, e);
            throw new IllegalArgumentException("Endpoint does not expose an empty constructor", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOGGER.error("Endpoint type {} could not be instantiated or threw an exception", endpointType, e);
            throw Optional.ofNullable((Exception)e.getCause()).orElse(e);
        }
    }
}

