/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.neonbee.NeonBee;
import io.neonbee.config.EndpointConfig;
import io.neonbee.endpoint.Endpoint;
import io.neonbee.endpoint.metrics.NeonBeePrometheusMeterRegistry;
import io.neonbee.endpoint.metrics.PrometheusScrapingHandler;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;

public class MetricsEndpoint
implements Endpoint {
    public static final String DEFAULT_BASE_PATH = "/metrics/";

    private static synchronized void addRegistry(Vertx vertx) {
        CompositeMeterRegistry compositeMeterRegistry = NeonBee.get(vertx).getCompositeMeterRegistry();
        boolean isNotRegisterd = compositeMeterRegistry.getRegistries().stream().noneMatch(NeonBeePrometheusMeterRegistry.class::isInstance);
        if (isNotRegisterd) {
            compositeMeterRegistry.add((MeterRegistry)new NeonBeePrometheusMeterRegistry(PrometheusConfig.DEFAULT));
        }
    }

    @Override
    public EndpointConfig getDefaultConfig() {
        return new EndpointConfig().setType(MetricsEndpoint.class.getName()).setBasePath(DEFAULT_BASE_PATH);
    }

    @Override
    public Future<Router> createEndpointRouter(Vertx vertx, String basePath, JsonObject config) {
        MetricsEndpoint.addRegistry(vertx);
        return Future.succeededFuture((Object)Endpoint.createRouter(vertx, (Handler<RoutingContext>)new PrometheusScrapingHandler(config.getString("registryName", NeonBee.get(vertx).getOptions().getMetricsRegistryName()))));
    }
}

