/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.neonbee.endpoint.metrics.NeonBeePrometheusMeterRegistry;
import io.neonbee.logging.LoggingFacade;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.micrometer.backends.BackendRegistries;
import io.vertx.micrometer.impl.PrometheusScrapingHandlerImpl;

public class PrometheusScrapingHandler
extends PrometheusScrapingHandlerImpl {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private final String registryName;

    public PrometheusScrapingHandler(String registryName) {
        super(registryName);
        this.registryName = registryName;
    }

    private static void noPrometheusMeterRegistryPresent(RoutingContext rc) {
        LOGGER.warn("Could not find a PrometheusMeterRegistry in the CompositeMeterRegistry");
        rc.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setStatusMessage("Could not find a PrometheusMeterRegistry").end();
    }

    private static void handleWithPrometheusMeterRegistry(RoutingContext rc, PrometheusMeterRegistry pmr) {
        rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain; version=0.0.4; charset=utf-8").end(pmr.scrape());
    }

    public void handle(RoutingContext rc) {
        MeterRegistry meterRegistry = this.registryName == null ? BackendRegistries.getDefaultNow() : BackendRegistries.getNow((String)this.registryName);
        if (meterRegistry instanceof CompositeMeterRegistry) {
            CompositeMeterRegistry cmr = (CompositeMeterRegistry)meterRegistry;
            cmr.getRegistries().stream().filter(registry -> registry instanceof NeonBeePrometheusMeterRegistry).findAny().map(PrometheusMeterRegistry.class::cast).ifPresentOrElse(pmr -> PrometheusScrapingHandler.handleWithPrometheusMeterRegistry(rc, pmr), () -> PrometheusScrapingHandler.noPrometheusMeterRegistryPresent(rc));
        } else {
            super.handle(rc);
        }
    }
}

