/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.endpoint.odatav4.ODataV4Endpoint;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.BatchProcessor;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.CountEntityCollectionProcessor;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.EntityProcessor;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.PrimitiveProcessor;
import io.neonbee.internal.helper.BufferHelper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataHandler;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.core.ODataHandlerException;

public final class OlingoEndpointHandler
implements Handler<RoutingContext> {
    private final ServiceMetadata serviceMetadata;

    public OlingoEndpointHandler(ServiceMetadata serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
    }

    public void handle(RoutingContext routingContext) {
        Vertx vertx = routingContext.vertx();
        Promise processPromise = Promise.promise();
        vertx.executeBlocking(blockingPromise -> {
            OData odata = OData.newInstance();
            ODataHandler odataHandler = odata.createRawHandler(this.serviceMetadata);
            odataHandler.register((Processor)new CountEntityCollectionProcessor(vertx, routingContext, (Promise<Void>)processPromise));
            odataHandler.register((Processor)new EntityProcessor(vertx, routingContext, (Promise<Void>)processPromise));
            odataHandler.register((Processor)new BatchProcessor(vertx, routingContext, (Promise<Void>)processPromise));
            odataHandler.register((Processor)new PrimitiveProcessor(vertx, routingContext, (Promise<Void>)processPromise));
            try {
                ODataResponse odataResponse = odataHandler.process(OlingoEndpointHandler.mapToODataRequest(routingContext, this.serviceMetadata.getEdm().getEntityContainer().getNamespace()));
                if (odataResponse.getStatusCode() != HttpResponseStatus.INTERNAL_SERVER_ERROR.code() || odataResponse.getContent() != null || odataResponse.getODataContent() != null) {
                    processPromise.tryComplete();
                }
                blockingPromise.complete((Object)odataResponse);
            }
            catch (ODataLibraryException e) {
                blockingPromise.fail((Throwable)e);
            }
        }, asyncODataResponse -> {
            if (asyncODataResponse.failed()) {
                Throwable cause = asyncODataResponse.cause();
                routingContext.fail(OlingoEndpointHandler.getStatusCode(cause), cause);
                return;
            }
            ODataResponse odataResponse = (ODataResponse)asyncODataResponse.result();
            processPromise.future().onComplete(asyncResult -> {
                if (asyncResult.failed()) {
                    Throwable cause = asyncResult.cause();
                    routingContext.fail(OlingoEndpointHandler.getStatusCode(cause), cause);
                    return;
                }
                try {
                    OlingoEndpointHandler.mapODataResponse(odataResponse, routingContext.response());
                }
                catch (IOException | ODataRuntimeException e) {
                    routingContext.fail(-1, e);
                }
            });
        });
    }

    private static int getStatusCode(Throwable throwable) {
        return throwable instanceof ODataApplicationException ? ((ODataApplicationException)throwable).getStatusCode() : -1;
    }

    @VisibleForTesting
    static ODataRequest mapToODataRequest(RoutingContext routingContext, String schemaNamespace) throws ODataLibraryException {
        HttpServerRequest request = routingContext.request();
        ODataRequest odataRequest = new ODataRequest();
        odataRequest.setProtocol(request.scheme());
        odataRequest.setMethod(OlingoEndpointHandler.mapODataRequestMethod(request));
        odataRequest.setBody((InputStream)new BufferHelper.BufferInputStream(routingContext.body().buffer()));
        for (String header : request.headers().names()) {
            odataRequest.addHeader(header, request.headers().getAll(header));
        }
        ODataV4Endpoint.NormalizedUri normalizedUri = ODataV4Endpoint.normalizeUri(routingContext, schemaNamespace);
        odataRequest.setRawRequestUri(normalizedUri.requestUri);
        odataRequest.setRawBaseUri(normalizedUri.baseUri);
        odataRequest.setRawServiceResolutionUri(normalizedUri.schemaNamespace);
        odataRequest.setRawODataPath(normalizedUri.resourcePath);
        odataRequest.setRawQueryPath(normalizedUri.requestQuery);
        return odataRequest;
    }

    @VisibleForTesting
    static HttpMethod mapODataRequestMethod(HttpServerRequest request) throws ODataLibraryException {
        HttpMethod odataRequestMethod;
        String rawMethod = request.method().name();
        try {
            odataRequestMethod = HttpMethod.valueOf((String)rawMethod);
        }
        catch (IllegalArgumentException e) {
            throw new ODataHandlerException("HTTP method not allowed" + rawMethod, (Throwable)e, (ODataLibraryException.MessageKey)ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, new String[]{rawMethod});
        }
        try {
            if (odataRequestMethod == HttpMethod.POST) {
                String xHttpMethod = request.getHeader("X-HTTP-Method");
                String xHttpMethodOverride = request.getHeader("X-HTTP-Method-Override");
                if (xHttpMethod == null && xHttpMethodOverride == null) {
                    return odataRequestMethod;
                }
                if (xHttpMethod == null) {
                    return HttpMethod.valueOf((String)xHttpMethodOverride);
                }
                if (xHttpMethodOverride == null) {
                    return HttpMethod.valueOf((String)xHttpMethod);
                }
                if (!xHttpMethod.equalsIgnoreCase(xHttpMethodOverride)) {
                    throw new ODataHandlerException("Ambiguous X-HTTP-Methods", (ODataLibraryException.MessageKey)ODataHandlerException.MessageKeys.AMBIGUOUS_XHTTP_METHOD, new String[]{xHttpMethod, xHttpMethodOverride});
                }
                return HttpMethod.valueOf((String)xHttpMethod);
            }
            return odataRequestMethod;
        }
        catch (IllegalArgumentException e) {
            throw new ODataHandlerException("Invalid HTTP method" + rawMethod, (Throwable)e, (ODataLibraryException.MessageKey)ODataHandlerException.MessageKeys.INVALID_HTTP_METHOD, new String[]{rawMethod});
        }
    }

    @VisibleForTesting
    static void mapODataResponse(ODataResponse odataResponse, HttpServerResponse response) throws IOException {
        response.setStatusCode(odataResponse.getStatusCode());
        for (Map.Entry entry : odataResponse.getAllHeaders().entrySet()) {
            for (String headerValue : (List)entry.getValue()) {
                response.putHeader((String)entry.getKey(), headerValue);
            }
        }
        if (odataResponse.getContent() != null) {
            response.end(BufferHelper.inputStreamToBuffer(odataResponse.getContent()));
        } else if (odataResponse.getODataContent() != null) {
            ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
            odataResponse.getODataContent().write((OutputStream)byteArrayOutput);
            response.end(Buffer.buffer((byte[])byteArrayOutput.toByteArray()));
        } else {
            response.end();
        }
    }
}

