/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.edm;

import io.neonbee.endpoint.odatav4.internal.olingo.expression.operands.ExpressionVisitorOperand;
import io.neonbee.entity.EntityModelManager;
import io.neonbee.logging.LoggingFacade;
import io.vertx.ext.web.RoutingContext;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;

public final class EdmHelper {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private static final Pattern STRING_KEY_PATTERN = Pattern.compile("'(.+)'");
    private static final Pattern NUMBER_KEY_PATTERN = Pattern.compile("([0-9]+)");
    private static final Pattern LOCAL_DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-1][0-9]-[0-3][0-9]");
    private static final Pattern LOCAL_DATETIME_PATTERN = Pattern.compile("[0-9]{4}-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-5][0-9]:[0-5][0-9]");

    private EdmHelper() {
    }

    public static EdmPrimitiveTypeKind getEdmPrimitiveTypeKindByPropertyType(String propertyType) throws ODataApplicationException {
        return Stream.of(EdmPrimitiveTypeKind.values()).filter(e -> e.getFullQualifiedName().toString().equals(propertyType) || e.getFullQualifiedName().toString().equals("Edm." + propertyType)).findFirst().orElseThrow(() -> new ODataApplicationException("No matching EdmPrimitiveTypeKind found for propertyType: " + propertyType, HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH));
    }

    public static Entity addKeyPredicateValues(Entity entity, UriResourceEntitySet uriResourceEntitySet, RoutingContext routingContext) {
        try {
            EdmEntityType edmEntityType = uriResourceEntitySet.getEntityType();
            for (UriParameter uriParam : uriResourceEntitySet.getKeyPredicates()) {
                String propertyName = uriParam.getName();
                EdmPrimitiveTypeKind edmPrimitiveTypeKind = EdmHelper.getEdmPrimitiveTypeKindByPropertyType(edmEntityType.getProperty(propertyName).getType().toString());
                String valueAsString = EdmHelper.extractValueFromLiteral(routingContext, uriParam.getText());
                EdmPrimitiveType edmPrimitiveType = EntityModelManager.getBufferedOData().createPrimitiveTypeInstance(edmPrimitiveTypeKind);
                EdmProperty edmProperty = (EdmProperty)edmEntityType.getProperty(propertyName);
                Object value = edmPrimitiveType.valueOfString(valueAsString, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(edmProperty.isUnicode()), edmPrimitiveType.getDefaultType());
                entity.addProperty(new Property(edmPrimitiveTypeKind.getFullQualifiedName().toString(), propertyName, ValueType.PRIMITIVE, value));
            }
        }
        catch (Exception e) {
            LOGGER.correlateWith(routingContext).error("Failed to add key predicate to the passed entity", e);
        }
        return entity;
    }

    public static String extractValueFromLiteral(String literal) {
        return EdmHelper.extractValueFromLiteral(null, literal);
    }

    public static String extractValueFromLiteral(RoutingContext routingContext, String literal) {
        try {
            if (String.valueOf(Boolean.TRUE).equalsIgnoreCase(literal) || String.valueOf(Boolean.FALSE).equalsIgnoreCase(literal)) {
                return literal.toLowerCase(Locale.ENGLISH);
            }
            Matcher matcher = STRING_KEY_PATTERN.matcher(literal);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            matcher = NUMBER_KEY_PATTERN.matcher(literal);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        catch (Exception e) {
            String msg = "Failed to extract value from literal";
            if (routingContext != null) {
                LOGGER.correlateWith(routingContext).error(msg, e);
            }
            LOGGER.error(msg, e);
        }
        return literal;
    }

    public static ExpressionVisitorOperand throwNotImplementedODataException() throws ODataApplicationException {
        throw new ODataApplicationException("Not implemented", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
    }

    public static boolean isLocalDate(String dateString) {
        Matcher matcher = LOCAL_DATE_PATTERN.matcher(dateString);
        return matcher.matches();
    }

    public static boolean isLocalDateTime(String dateTimeString) {
        Matcher matcher = LOCAL_DATETIME_PATTERN.matcher(dateTimeString);
        return matcher.matches();
    }

    public static Property convertStringValueToEdmProperty(String valueAsString, EdmProperty edmProperty) throws EdmPrimitiveTypeException {
        EdmPrimitiveType edmType = (EdmPrimitiveType)edmProperty.getType();
        Object value = edmType.valueOfString(valueAsString, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(edmProperty.isUnicode()), edmType.getDefaultType());
        return new Property(edmType.getName(), edmProperty.getName(), ValueType.PRIMITIVE, value);
    }
}

