/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.edm;

import java.util.Objects;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;

public final class EdmPrimitiveNull
implements EdmPrimitiveType {
    private static final EdmPrimitiveNull SINGLETON_INSTANCE = new EdmPrimitiveNull();
    private static final String NULL_STRING = "null";

    public static EdmPrimitiveNull getInstance() {
        return SINGLETON_INSTANCE;
    }

    public boolean equals(Object object) {
        return this == object || object != null && this.getClass() == object.getClass();
    }

    public int hashCode() {
        return Objects.hash(this, this.getClass());
    }

    public String fromUriLiteral(String literal) throws EdmPrimitiveTypeException {
        return literal;
    }

    public String toUriLiteral(String literal) {
        return literal;
    }

    public Class<?> getDefaultType() {
        return null;
    }

    public FullQualifiedName getFullQualifiedName() {
        return new FullQualifiedName(this.getNamespace(), this.getName());
    }

    public EdmTypeKind getKind() {
        return EdmTypeKind.PRIMITIVE;
    }

    public String getName() {
        return "Null";
    }

    public String getNamespace() {
        return "Edm";
    }

    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return this.equals(primitiveType);
    }

    public String toString() {
        return this.getFullQualifiedName().getFullQualifiedNameAsString();
    }

    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        return value == null && (isNullable == null || isNullable != false) || NULL_STRING.equals(value);
    }

    public <T> T valueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        if (value == null) {
            if (isNullable != null && Boolean.FALSE.equals(isNullable)) {
                throw new EdmPrimitiveTypeException("Error: The literal 'null' is not allowed");
            }
            return null;
        }
        if (NULL_STRING.equals(value)) {
            return null;
        }
        throw new EdmPrimitiveTypeException("Error: The literal '" + value + "' has illegal content");
    }

    public String valueToString(Object value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value == null) {
            if (isNullable != null && Boolean.FALSE.equals(isNullable)) {
                throw new EdmPrimitiveTypeException("Error: The value 'null' is not allowed");
            }
            return null;
        }
        return NULL_STRING;
    }
}

