/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.expression;

import io.neonbee.endpoint.odatav4.internal.olingo.edm.EdmConstants;
import io.neonbee.endpoint.odatav4.internal.olingo.edm.EdmHelper;
import io.neonbee.logging.LoggingFacade;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;

public interface EntityComparison {
    public static final LoggingFacade LOGGER = LoggingFacade.create();

    private BigInteger toBigInteger(Object object) {
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        return new BigInteger(String.valueOf(object));
    }

    private BigDecimal toBigDecimal(Object object) {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof BigInteger) {
            return new BigDecimal((BigInteger)object);
        }
        return new BigDecimal(String.valueOf(object));
    }

    private Long dateTimeObjectToLong(RoutingContext routingContext, Object object) throws ODataApplicationException {
        if (object instanceof Time) {
            return ((Time)object).getTime();
        }
        return this.dateTimeObjectToInstant(routingContext, object).toEpochMilli();
    }

    default public Instant dateTimeObjectToInstant(RoutingContext routingContext, Object object) throws ODataApplicationException {
        Instant instant;
        block9: {
            try {
                if (object instanceof Date) {
                    instant = ((Date)object).toInstant().atZone(ZoneId.systemDefault()).toInstant();
                    break block9;
                }
                if (object instanceof Instant) {
                    instant = ((Instant)object).atZone(ZoneId.systemDefault()).toInstant();
                    break block9;
                }
                if (object instanceof Timestamp) {
                    instant = ((Timestamp)object).toInstant().atZone(ZoneId.systemDefault()).toInstant();
                    break block9;
                }
                if (object instanceof Long) {
                    instant = Instant.ofEpochMilli((Long)object).atZone(ZoneId.systemDefault()).toInstant();
                    break block9;
                }
                if (object instanceof LocalDate) {
                    instant = ((LocalDate)object).atStartOfDay(ZoneId.systemDefault()).toInstant();
                    break block9;
                }
                if (object instanceof Calendar) {
                    instant = ((Calendar)object).toInstant().atZone(ZoneId.systemDefault()).toInstant();
                    break block9;
                }
                if (object instanceof String) {
                    String stringValue = (String)object;
                    instant = EdmHelper.isLocalDate(stringValue) ? LocalDate.parse(stringValue).atStartOfDay(ZoneId.systemDefault()).toInstant() : (EdmHelper.isLocalDateTime(stringValue) ? LocalDateTime.parse(stringValue).atZone(ZoneId.systemDefault()).toInstant() : Instant.parse(stringValue).atZone(ZoneId.systemDefault()).toInstant());
                    break block9;
                }
                String message = "Converting object of type" + object.getClass() + " is not yet supported.";
                LOGGER.correlateWith(routingContext).error(message);
                throw new ODataApplicationException(message, HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
            }
            catch (IllegalArgumentException | NullPointerException | DateTimeParseException e) {
                String message = "Converting object of type" + object.getClass() + " failed.";
                LOGGER.correlateWith(routingContext).error(message);
                throw new ODataApplicationException(message, HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ENGLISH, (Throwable)e);
            }
        }
        return instant;
    }

    default public boolean instanceOfExpectedType(List<Class<?>> listOfClasses, Object value1) {
        return listOfClasses.stream().anyMatch(c -> c.isAssignableFrom(value1.getClass()));
    }

    default public boolean instanceOfExpectedType(List<Class<?>> listOfClasses, Object value1, Object value2) {
        return this.instanceOfExpectedType(listOfClasses, value1) && this.instanceOfExpectedType(listOfClasses, value2);
    }

    default public RuntimeException createAndLogException(RoutingContext routingContext, List<Class<?>> listOfClasses, Object value1, Object value2, String propertyName) {
        String messageTemplate = "An error has occurred while comparing two values of property %s. The types of the compared values are %s and %s but both must be one of: %s";
        String message = String.format(messageTemplate, propertyName, value1.getClass().getSimpleName(), value2.getClass().getSimpleName(), listOfClasses.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
        IllegalArgumentException exception = new IllegalArgumentException(new ODataApplicationException(message, HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ENGLISH));
        this.errorLog(routingContext, message, exception);
        return exception;
    }

    default public int comparePropertyValues(RoutingContext routingContext, Object leadingPropertyValue1, Object propertyValue2, EdmPrimitiveTypeKind propertyTypeKind, String propertyName) {
        switch (propertyTypeKind) {
            case Binary: {
                if (this.instanceOfExpectedType(EdmConstants.EDM_BINARY_JAVA_TYPES, leadingPropertyValue1)) {
                    try {
                        return Integer.compare(Array.getLength(leadingPropertyValue1), Array.getLength(propertyValue2));
                    }
                    catch (Exception e) {
                        this.errorLog(routingContext, e);
                    }
                }
                throw this.createAndLogException(routingContext, EdmConstants.EDM_BINARY_JAVA_TYPES, leadingPropertyValue1, propertyValue2, propertyName);
            }
            case Int16: 
            case Int32: 
            case Int64: 
            case Byte: 
            case SByte: {
                if (this.instanceOfExpectedType(EdmConstants.EDM_INT16_INT32_INT64_BYTE_SBYTE_JAVA_TYPES, leadingPropertyValue1)) {
                    try {
                        return this.toBigInteger(leadingPropertyValue1).compareTo(this.toBigInteger(propertyValue2));
                    }
                    catch (Exception e) {
                        this.errorLog(routingContext, e);
                    }
                }
                throw this.createAndLogException(routingContext, EdmConstants.EDM_INT16_INT32_INT64_BYTE_SBYTE_JAVA_TYPES, leadingPropertyValue1, propertyValue2, propertyName);
            }
            case Decimal: 
            case Duration: {
                if (this.instanceOfExpectedType(EdmConstants.EDM_DECIMAL_DURATION_JAVA_TYPES, leadingPropertyValue1)) {
                    try {
                        return this.toBigDecimal(leadingPropertyValue1).compareTo(this.toBigDecimal(propertyValue2));
                    }
                    catch (Exception e) {
                        this.errorLog(routingContext, e);
                    }
                }
                throw this.createAndLogException(routingContext, EdmConstants.EDM_DECIMAL_DURATION_JAVA_TYPES, leadingPropertyValue1, propertyValue2, propertyName);
            }
            case Single: 
            case Double: {
                if (this.instanceOfExpectedType(EdmConstants.EDM_SINGLE_DOUBLE_JAVA_TYPES, leadingPropertyValue1)) {
                    try {
                        return this.toBigDecimal(leadingPropertyValue1).compareTo(this.toBigDecimal(propertyValue2));
                    }
                    catch (Exception e) {
                        this.errorLog(routingContext, e);
                    }
                }
                throw this.createAndLogException(routingContext, EdmConstants.EDM_SINGLE_DOUBLE_JAVA_TYPES, leadingPropertyValue1, propertyValue2, propertyName);
            }
            case Date: 
            case TimeOfDay: 
            case DateTimeOffset: {
                if (this.instanceOfExpectedType(EdmConstants.EDM_DATE_TIMEOFDAY_DATETIMEOFFSET_JAVA_TYPES, leadingPropertyValue1)) {
                    try {
                        return this.dateTimeObjectToLong(routingContext, leadingPropertyValue1).compareTo(this.dateTimeObjectToLong(routingContext, propertyValue2));
                    }
                    catch (Exception e) {
                        this.errorLog(routingContext, e);
                    }
                }
                throw this.createAndLogException(routingContext, EdmConstants.EDM_DATE_TIMEOFDAY_DATETIMEOFFSET_JAVA_TYPES, leadingPropertyValue1, propertyValue2, propertyName);
            }
            case Boolean: {
                if (this.instanceOfExpectedType(EdmConstants.EDM_BOOLEAN_JAVA_TYPES, leadingPropertyValue1)) {
                    try {
                        return Boolean.compare((Boolean)leadingPropertyValue1, (Boolean)propertyValue2);
                    }
                    catch (Exception e) {
                        this.errorLog(routingContext, e);
                    }
                }
                throw this.createAndLogException(routingContext, EdmConstants.EDM_BOOLEAN_JAVA_TYPES, leadingPropertyValue1, propertyValue2, propertyName);
            }
            case String: {
                if (this.instanceOfExpectedType(EdmConstants.EDM_STRING_JAVA_TYPES, leadingPropertyValue1)) {
                    try {
                        return ((String)leadingPropertyValue1).compareToIgnoreCase((String)propertyValue2);
                    }
                    catch (Exception e) {
                        this.errorLog(routingContext, e);
                    }
                }
                throw this.createAndLogException(routingContext, EdmConstants.EDM_STRING_JAVA_TYPES, leadingPropertyValue1, propertyValue2, propertyName);
            }
            case Guid: {
                if (this.instanceOfExpectedType(EdmConstants.EDM_GUID_JAVA_TYPES, leadingPropertyValue1)) {
                    try {
                        return ((UUID)leadingPropertyValue1).compareTo((UUID)propertyValue2);
                    }
                    catch (Exception e) {
                        this.errorLog(routingContext, e);
                    }
                }
                throw this.createAndLogException(routingContext, EdmConstants.EDM_GUID_JAVA_TYPES, leadingPropertyValue1, propertyValue2, propertyName);
            }
        }
        throw new IllegalArgumentException(new ODataApplicationException("Error during comparison of entity properties.", HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ENGLISH));
    }

    private void errorLog(RoutingContext routingContext, Exception e) {
        this.errorLog(routingContext, null, e);
    }

    private void errorLog(RoutingContext routingContext, String message, Exception e) {
        if (message != null) {
            if (routingContext != null) {
                LOGGER.correlateWith(routingContext).error(message, e);
            } else {
                LOGGER.error(message, e);
            }
        } else if (routingContext != null) {
            LOGGER.correlateWith(routingContext).error(e.getMessage(), e);
        } else {
            LOGGER.error(e.getMessage(), e);
        }
    }
}

