/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.expression.operators;

import io.neonbee.endpoint.odatav4.internal.olingo.edm.EdmConstants;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.operands.ExpressionVisitorOperand;
import io.neonbee.logging.LoggingFacade;
import io.vertx.ext.web.RoutingContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;

public class BinaryOperator {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private final RoutingContext routingContext;
    private final ExpressionVisitorOperand leftOperand;
    private ExpressionVisitorOperand rightOperand;
    private List<ExpressionVisitorOperand> rightOperands;

    public BinaryOperator(RoutingContext routingContext, ExpressionVisitorOperand leftOperand, List<ExpressionVisitorOperand> rightOperands) throws ODataApplicationException {
        this.routingContext = routingContext;
        this.rightOperands = rightOperands.stream().map(operand -> {
            try {
                return operand.setType();
            }
            catch (ODataApplicationException e) {
                LOGGER.correlateWith(routingContext).error("Can't set type of operand", e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.leftOperand = leftOperand.setType();
    }

    public BinaryOperator(RoutingContext routingContext, ExpressionVisitorOperand leftOperand, ExpressionVisitorOperand rightOperand) throws ODataApplicationException {
        this.routingContext = routingContext;
        this.leftOperand = leftOperand.setType().normalizeTypes(rightOperand.setType());
        this.rightOperand = rightOperand.setType().normalizeTypes(leftOperand);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.correlateWith(routingContext).trace("leftOperand: {}", leftOperand);
            LOGGER.correlateWith(routingContext).trace("rightOperand: {}", rightOperand);
        }
    }

    public ExpressionVisitorOperand andOperator() throws ODataApplicationException {
        if (this.leftOperand.isBooleanType() && this.rightOperand.isBooleanType()) {
            Boolean result = null;
            if (Boolean.TRUE.equals(this.leftOperand.getValue()) && Boolean.TRUE.equals(this.rightOperand.getValue())) {
                result = true;
            } else if (Boolean.FALSE.equals(this.leftOperand.getValue()) || Boolean.FALSE.equals(this.rightOperand.getValue())) {
                result = false;
            }
            return new ExpressionVisitorOperand(this.routingContext, result, (EdmType)EdmConstants.PRIMITIVE_BOOLEAN);
        }
        String message = "And operator needs two binary operands";
        LOGGER.correlateWith(this.routingContext).error(message);
        throw new ODataApplicationException(message, HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ENGLISH);
    }

    private boolean binaryComparison(int ... expected) {
        int result = this.leftOperand.isNull() && this.rightOperand.isNull() ? 0 : (this.leftOperand.isIntegerType() ? this.leftOperand.getTypedValue(BigInteger.class).compareTo(this.rightOperand.getTypedValue(BigInteger.class)) : (this.leftOperand.isDecimalType() ? this.leftOperand.getTypedValue(BigDecimal.class).compareTo(this.rightOperand.getTypedValue(BigDecimal.class)) : (this.leftOperand.getValue().getClass() == this.rightOperand.getValue().getClass() && this.leftOperand.getValue() instanceof Comparable ? ((Comparable)this.leftOperand.getValue()).compareTo(this.rightOperand.getValue()) : (this.leftOperand.getValue().equals(this.rightOperand.getValue()) ? 0 : 1))));
        return Arrays.stream(expected).anyMatch(i -> i == result);
    }

    public ExpressionVisitorOperand equalsOperator() {
        boolean result = this.isBinaryComparisonNecessary() && this.binaryComparison(0);
        return new ExpressionVisitorOperand(this.routingContext, result, (EdmType)EdmConstants.PRIMITIVE_BOOLEAN);
    }

    public ExpressionVisitorOperand greaterEqualsOperator() {
        boolean result = this.isBinaryComparisonNecessary() && this.binaryComparison(1, 0);
        return new ExpressionVisitorOperand(this.routingContext, result, (EdmType)EdmConstants.PRIMITIVE_BOOLEAN);
    }

    public ExpressionVisitorOperand greaterThanOperator() {
        boolean result = this.isBinaryComparisonNecessary() && this.binaryComparison(1);
        return new ExpressionVisitorOperand(this.routingContext, result, (EdmType)EdmConstants.PRIMITIVE_BOOLEAN);
    }

    public ExpressionVisitorOperand inOperator() {
        if (this.rightOperands != null && !this.rightOperands.isEmpty() && this.rightOperands.stream().anyMatch(rightOperandTyped -> rightOperandTyped.getTypedValue(String.class).equals(this.leftOperand.getTypedValue(String.class)))) {
            return new ExpressionVisitorOperand(this.routingContext, true, (EdmType)EdmConstants.PRIMITIVE_BOOLEAN);
        }
        return new ExpressionVisitorOperand(this.routingContext, false, (EdmType)EdmConstants.PRIMITIVE_BOOLEAN);
    }

    private boolean isBinaryComparisonNecessary() {
        return !(this.leftOperand.isNull() ^ this.rightOperand.isNull());
    }

    public ExpressionVisitorOperand lessEqualsOperator() {
        boolean result = this.isBinaryComparisonNecessary() && this.binaryComparison(-1, 0);
        return new ExpressionVisitorOperand(this.routingContext, result, (EdmType)EdmConstants.PRIMITIVE_BOOLEAN);
    }

    public ExpressionVisitorOperand lessThanOperator() {
        boolean result = this.isBinaryComparisonNecessary() && this.binaryComparison(-1);
        return new ExpressionVisitorOperand(this.routingContext, result, (EdmType)EdmConstants.PRIMITIVE_BOOLEAN);
    }

    public ExpressionVisitorOperand notEqualsOperator() {
        ExpressionVisitorOperand equalsOperator = this.equalsOperator();
        return new ExpressionVisitorOperand(this.routingContext, (Boolean)equalsOperator.getValue() == false, (EdmType)EdmConstants.PRIMITIVE_BOOLEAN);
    }

    public ExpressionVisitorOperand orOperator() throws ODataApplicationException {
        if (this.leftOperand.is(EdmConstants.PRIMITIVE_BOOLEAN) && this.rightOperand.is(EdmConstants.PRIMITIVE_BOOLEAN)) {
            Boolean result = null;
            if (Boolean.TRUE.equals(this.leftOperand.getValue()) || Boolean.TRUE.equals(this.rightOperand.getValue())) {
                result = true;
            } else if (Boolean.FALSE.equals(this.leftOperand.getValue()) && Boolean.FALSE.equals(this.rightOperand.getValue())) {
                result = false;
            }
            return new ExpressionVisitorOperand(this.routingContext, result, (EdmType)EdmConstants.PRIMITIVE_BOOLEAN);
        }
        String message = "Or operator needs two binary operands";
        LOGGER.correlateWith(this.routingContext).error(message);
        throw new ODataApplicationException(message, HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ENGLISH);
    }
}

