/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.expression.operators;

import io.neonbee.endpoint.odatav4.internal.olingo.edm.EdmConstants;
import io.neonbee.endpoint.odatav4.internal.olingo.edm.EdmPrimitiveNull;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.EntityComparison;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.operands.ExpressionVisitorOperand;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.operators.MethodCallOperator;
import io.neonbee.logging.LoggingFacade;
import io.vertx.ext.web.RoutingContext;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;

public class DateFunctionMethodCallOperator
extends MethodCallOperator
implements EntityComparison {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private static final long ONE_SECOND_AS_NANOS = TimeUnit.SECONDS.toNanos(1L);

    public DateFunctionMethodCallOperator(RoutingContext routingContext, List<ExpressionVisitorOperand> parameters) {
        super(routingContext, parameters);
    }

    public ExpressionVisitorOperand fractionalseconds() throws ODataApplicationException {
        return this.dateFunction((instant, operand) -> {
            if (operand.getValue() instanceof Timestamp) {
                return new BigDecimal(operand.getTypedValue(Timestamp.class).getNanos()).divide(BigDecimal.valueOf(ONE_SECOND_AS_NANOS));
            }
            return new BigDecimal(instant.getNano()).divide(BigDecimal.valueOf(ONE_SECOND_AS_NANOS));
        }, (EdmType)EdmConstants.PRIMITIVE_DECIMAL, EdmConstants.PRIMITIVE_DATE_TIME_OFFSET, EdmConstants.PRIMITIVE_TIME_OF_DAY);
    }

    public ExpressionVisitorOperand second() throws ODataApplicationException {
        return this.dateFunction((instant, operand) -> instant.atZone(ZoneId.systemDefault()).getSecond(), (EdmType)EdmConstants.PRIMITIVE_INT32, EdmConstants.PRIMITIVE_DATE_TIME_OFFSET, EdmConstants.PRIMITIVE_TIME_OF_DAY);
    }

    public ExpressionVisitorOperand hour() throws ODataApplicationException {
        return this.dateFunction((instant, operand) -> instant.atZone(ZoneId.systemDefault()).getHour(), (EdmType)EdmConstants.PRIMITIVE_INT32, EdmConstants.PRIMITIVE_DATE_TIME_OFFSET, EdmConstants.PRIMITIVE_TIME_OF_DAY);
    }

    public ExpressionVisitorOperand minute() throws ODataApplicationException {
        return this.dateFunction((instant, operand) -> instant.atZone(ZoneId.systemDefault()).getMinute(), (EdmType)EdmConstants.PRIMITIVE_INT32, EdmConstants.PRIMITIVE_DATE_TIME_OFFSET, EdmConstants.PRIMITIVE_TIME_OF_DAY);
    }

    public ExpressionVisitorOperand day() throws ODataApplicationException {
        return this.dateFunction((instant, operand) -> instant.atZone(ZoneId.systemDefault()).getDayOfMonth(), (EdmType)EdmConstants.PRIMITIVE_INT32, EdmConstants.PRIMITIVE_DATE_TIME_OFFSET, EdmConstants.PRIMITIVE_DATE);
    }

    public ExpressionVisitorOperand month() throws ODataApplicationException {
        return this.dateFunction((instant, operand) -> instant.atZone(ZoneId.systemDefault()).getMonthValue(), (EdmType)EdmConstants.PRIMITIVE_INT32, EdmConstants.PRIMITIVE_DATE_TIME_OFFSET, EdmConstants.PRIMITIVE_DATE);
    }

    public ExpressionVisitorOperand year() throws ODataApplicationException {
        return this.dateFunction((instant, operand) -> instant.atZone(ZoneId.systemDefault()).getYear(), (EdmType)EdmConstants.PRIMITIVE_INT32, EdmConstants.PRIMITIVE_DATE_TIME_OFFSET, EdmConstants.PRIMITIVE_DATE);
    }

    private ExpressionVisitorOperand dateFunction(MethodCallOperator.DateFunction dateFunction, EdmType returnType, EdmPrimitiveType ... expectedTypes) throws ODataApplicationException {
        ExpressionVisitorOperand operand = ((ExpressionVisitorOperand)this.parameters.get(0)).setType();
        if (operand.isNull()) {
            return new ExpressionVisitorOperand(this.routingContext, null, (EdmType)EdmPrimitiveNull.getInstance());
        }
        if (operand.is(expectedTypes) && (operand.is(EdmConstants.PRIMITIVE_DATE) || operand.is(EdmConstants.PRIMITIVE_DATE_TIME_OFFSET) || operand.is(EdmConstants.PRIMITIVE_TIME_OF_DAY))) {
            Object value = operand.getValue();
            Instant instant = this.dateTimeObjectToInstant(this.routingContext, value);
            return new ExpressionVisitorOperand(this.routingContext, dateFunction.perform(instant, operand), returnType);
        }
        LOGGER.correlateWith(this.routingContext).error("Invalid type");
        throw new ODataApplicationException("Invalid type", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ENGLISH);
    }
}

