/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.expression.operators;

import io.neonbee.endpoint.odatav4.internal.olingo.edm.EdmConstants;
import io.neonbee.endpoint.odatav4.internal.olingo.edm.EdmPrimitiveNull;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.operands.ExpressionVisitorOperand;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.operators.MethodCallOperator;
import io.neonbee.logging.LoggingFacade;
import io.vertx.ext.web.RoutingContext;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;

public class StringFunctionMethodCallOperator
extends MethodCallOperator {
    private static final LoggingFacade LOGGER = LoggingFacade.create();

    public StringFunctionMethodCallOperator(RoutingContext routingContext, List<ExpressionVisitorOperand> parameters) {
        super(routingContext, parameters);
    }

    public ExpressionVisitorOperand startsWith() throws ODataApplicationException {
        return this.stringFunction(params -> ((String)params.get(0)).startsWith((String)params.get(1)), (EdmType)EdmConstants.PRIMITIVE_BOOLEAN);
    }

    public ExpressionVisitorOperand endsWith() throws ODataApplicationException {
        return this.stringFunction(params -> ((String)params.get(0)).endsWith((String)params.get(1)), (EdmType)EdmConstants.PRIMITIVE_BOOLEAN);
    }

    public ExpressionVisitorOperand indexOf() throws ODataApplicationException {
        return this.stringFunction(params -> ((String)params.get(0)).indexOf((String)params.get(1)), (EdmType)EdmConstants.PRIMITIVE_INT32);
    }

    public ExpressionVisitorOperand length() throws ODataApplicationException {
        return this.stringFunction(params -> ((String)params.get(0)).length(), (EdmType)EdmConstants.PRIMITIVE_INT32);
    }

    public ExpressionVisitorOperand substring() throws ODataApplicationException {
        ExpressionVisitorOperand valueOperand = ((ExpressionVisitorOperand)this.parameters.get(0)).setType();
        ExpressionVisitorOperand startOperand = ((ExpressionVisitorOperand)this.parameters.get(1)).setType();
        if (!startOperand.isIntegerType()) {
            startOperand = startOperand.setType(EdmConstants.PRIMITIVE_INT32);
        }
        if (valueOperand.isNull() || startOperand.isNull()) {
            return new ExpressionVisitorOperand(this.routingContext, null, (EdmType)EdmConstants.PRIMITIVE_STRING);
        }
        if (valueOperand.is(EdmConstants.PRIMITIVE_STRING)) {
            String value = valueOperand.getTypedValue(String.class);
            int start = Math.max(0, Math.min(startOperand.getTypedValue(BigInteger.class).intValue(), value.length()));
            int end = value.length();
            if (this.parameters.size() == 3) {
                ExpressionVisitorOperand lengthOperand = ((ExpressionVisitorOperand)this.parameters.get(2)).setType(EdmConstants.PRIMITIVE_INT32);
                if (lengthOperand.isNull()) {
                    return new ExpressionVisitorOperand(this.routingContext, null, (EdmType)EdmConstants.PRIMITIVE_STRING);
                }
                if (lengthOperand.isIntegerType()) {
                    end = Math.max(0, Math.min(start + lengthOperand.getTypedValue(BigInteger.class).intValue(), value.length()));
                } else {
                    String message = "Third substring parameter should be Edm.Int32";
                    LOGGER.correlateWith(this.routingContext).error(message);
                    throw new ODataApplicationException(message, HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ENGLISH);
                }
            }
            return new ExpressionVisitorOperand(this.routingContext, value.substring(start, end), (EdmType)EdmConstants.PRIMITIVE_STRING);
        }
        String message = "Substring has invalid parameters. First parameter should be Edm.String, second parameter should be Edm.Int32";
        LOGGER.correlateWith(this.routingContext).error(message);
        throw new ODataApplicationException(message, HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ENGLISH);
    }

    public ExpressionVisitorOperand toLower() throws ODataApplicationException {
        return this.stringFunction(params -> ((String)params.get(0)).toLowerCase(Locale.ENGLISH), (EdmType)EdmConstants.PRIMITIVE_STRING);
    }

    public ExpressionVisitorOperand toUpper() throws ODataApplicationException {
        return this.stringFunction(params -> ((String)params.get(0)).toUpperCase(Locale.ENGLISH), (EdmType)EdmConstants.PRIMITIVE_STRING);
    }

    public ExpressionVisitorOperand trim() throws ODataApplicationException {
        return this.stringFunction(params -> ((String)params.get(0)).trim(), (EdmType)EdmConstants.PRIMITIVE_STRING);
    }

    public ExpressionVisitorOperand concat() throws ODataApplicationException {
        return this.stringFunction(params -> (String)params.get(0) + (String)params.get(1), (EdmType)EdmConstants.PRIMITIVE_STRING);
    }

    public ExpressionVisitorOperand contains() throws ODataApplicationException {
        return this.stringFunction(parameters -> ((String)parameters.get(0)).contains((CharSequence)parameters.get(1)), (EdmType)EdmConstants.PRIMITIVE_BOOLEAN, () -> new ExpressionVisitorOperand(this.routingContext, false, (EdmType)EdmConstants.PRIMITIVE_BOOLEAN));
    }

    private List<String> getParametersAsString() throws ODataApplicationException {
        ArrayList<String> result = new ArrayList<String>();
        for (ExpressionVisitorOperand parameter : this.parameters) {
            ExpressionVisitorOperand operand = parameter.setType();
            if (operand.isNull()) {
                result.add(null);
                continue;
            }
            if (operand.is(EdmConstants.PRIMITIVE_STRING)) {
                result.add(operand.getTypedValue(String.class));
                continue;
            }
            String message = "Invalid parameter. Expected parameter of type Edm.String.";
            LOGGER.correlateWith(this.routingContext).error(message);
            throw new ODataApplicationException(message, HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ENGLISH);
        }
        return result;
    }

    private ExpressionVisitorOperand stringFunction(MethodCallOperator.StringFunction stringFunction, EdmType returnValue) throws ODataApplicationException {
        return this.stringFunction(stringFunction, returnValue, () -> new ExpressionVisitorOperand(this.routingContext, null, (EdmType)EdmPrimitiveNull.getInstance()));
    }

    private ExpressionVisitorOperand stringFunction(MethodCallOperator.StringFunction stringFunction, EdmType returnValue, Supplier<ExpressionVisitorOperand> nullParameterOperandSupplier) throws ODataApplicationException {
        List<String> stringParameters = this.getParametersAsString();
        if (stringParameters.contains(null)) {
            return nullParameterOperandSupplier.get();
        }
        return new ExpressionVisitorOperand(this.routingContext, stringFunction.perform(stringParameters), returnValue);
    }
}

