/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.processor;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.apache.olingo.server.api.processor.Processor;

public abstract class AsynchronousProcessor
implements Processor {
    private static final String PROCESSING_STACK = "processingStack";
    protected Vertx vertx;
    protected RoutingContext routingContext;
    private final Promise<Void> processPromise;
    private Promise<Void> subProcessPromise;

    AsynchronousProcessor(Vertx vertx, RoutingContext routingContext, Promise<Void> processPromise) {
        this.vertx = vertx;
        this.routingContext = routingContext;
        this.processPromise = processPromise;
    }

    public Promise<Void> getProcessPromise() {
        if (this.subProcessPromise != null) {
            return this.subProcessPromise;
        }
        if (AsynchronousProcessor.processingStack().isEmpty()) {
            return this.processPromise;
        }
        this.subProcessPromise = Promise.promise();
        Objects.requireNonNull(AsynchronousProcessor.processingStack().peek(), "head of deque is empty").add((Future<Void>)this.subProcessPromise.future());
        return this.subProcessPromise;
    }

    public Promise<Void> enterBatchProcessing() {
        Promise<Void> processPromise = this.getProcessPromise();
        AsynchronousProcessor.processingStack().push(new ArrayList());
        return processPromise;
    }

    public List<Future<Void>> wrapUpBatchProcessing() {
        return AsynchronousProcessor.processingStack().pop();
    }

    private static Deque<List<Future<Void>>> processingStack() {
        Context context = Vertx.currentContext();
        ArrayDeque processingStack = (ArrayDeque)context.get((Object)PROCESSING_STACK);
        if (Objects.isNull(processingStack)) {
            processingStack = new ArrayDeque();
            context.put((Object)PROCESSING_STACK, processingStack);
        }
        return processingStack;
    }
}

