/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.processor;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.neonbee.data.DataAction;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.FilterExpressionVisitor;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.OrderExpressionExecutor;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.operands.ExpressionVisitorOperand;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.AsynchronousProcessor;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.EntityExpander;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.EntityProcessor;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.NavigationPropertyHelper;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.ProcessorHelper;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_INTERFACE"}, justification="Common practice in Olingo to name the implementation of the processor same as the interface")
public class CountEntityCollectionProcessor
extends AsynchronousProcessor
implements org.apache.olingo.server.api.processor.CountEntityCollectionProcessor {
    @VisibleForTesting
    static final UnsupportedOperationException TOO_MANY_PARTS_EXCEPTION = new UnsupportedOperationException("Read requests with more than two resource parts are not supported.");
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private OData odata;
    private ServiceMetadata serviceMetadata;

    public CountEntityCollectionProcessor(Vertx vertx, RoutingContext routingContext, Promise<Void> processPromise) {
        super(vertx, routingContext, processPromise);
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
    }

    public void readEntityCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) {
        List resourceParts = uriInfo.getUriResourceParts();
        if (resourceParts.size() > 2) {
            throw TOO_MANY_PARTS_EXCEPTION;
        }
        Promise<Void> processPromise = this.getProcessPromise();
        UriResourceEntitySet uriResourceEntitySet = (UriResourceEntitySet)uriInfo.getUriResourceParts().get(0);
        EdmEntityType edmEntityType = uriResourceEntitySet.getEntitySet().getEntityType();
        EntityCollection entityCollection = new EntityCollection();
        Promise responsePromise = Promise.promise();
        ProcessorHelper.forwardRequest(request, DataAction.READ, uriInfo, this.vertx, this.routingContext, processPromise).onSuccess(ew -> {
            block9: {
                boolean expandExecuted = Optional.ofNullable((Boolean)this.routingContext.get("response.OData.expand")).orElse(Boolean.FALSE);
                if (resourceParts.size() == 1) {
                    try {
                        boolean filterExecuted = Optional.ofNullable((Boolean)this.routingContext.get("response.OData.filter")).orElse(Boolean.FALSE);
                        List<Entity> resultEntityList = filterExecuted ? ew.getEntities() : this.applyFilterQueryOption(uriInfo.getFilterOption(), ew.getEntities());
                        this.applyCountOption(uriInfo.getCountOption(), resultEntityList, entityCollection);
                        if (!resultEntityList.isEmpty()) {
                            boolean skipExecuted;
                            boolean orderByExecuted = Optional.ofNullable((Boolean)this.routingContext.get("response.OData.orderby")).orElse(Boolean.FALSE);
                            if (!orderByExecuted) {
                                this.applyOrderByQueryOption(uriInfo.getOrderByOption(), resultEntityList);
                            }
                            resultEntityList = (skipExecuted = Optional.ofNullable((Boolean)this.routingContext.get("response.OData.skip")).orElse(Boolean.FALSE).booleanValue()) ? resultEntityList : this.applySkipQueryOption(uriInfo.getSkipOption(), resultEntityList);
                            boolean topExecuted = Optional.ofNullable((Boolean)this.routingContext.get("response.OData.top")).orElse(Boolean.FALSE);
                            resultEntityList = topExecuted ? resultEntityList : this.applyTopQueryOption(uriInfo.getTopOption(), resultEntityList);
                            Future<List<Entity>> resultEntityListFuture = expandExecuted ? Future.succeededFuture(resultEntityList) : this.applyExpandQueryOptions(uriInfo, resultEntityList);
                            resultEntityListFuture.onComplete((Handler)responsePromise);
                            break block9;
                        }
                        responsePromise.complete(resultEntityList);
                    }
                    catch (ODataException e) {
                        processPromise.fail((Throwable)e);
                    }
                } else {
                    try {
                        Entity foundEntity;
                        boolean keyPredicateExecuted = Optional.ofNullable((Boolean)this.routingContext.get("OData.key")).orElse(Boolean.FALSE);
                        Entity entity = foundEntity = keyPredicateExecuted ? ew.getEntities().get(0) : EntityProcessor.findEntityByKeyPredicates(this.routingContext, uriResourceEntitySet, ew.getEntities());
                        if (!expandExecuted) {
                            NavigationPropertyHelper.fetchNavigationTargetEntities((UriResource)resourceParts.get(1), foundEntity, this.vertx, this.routingContext).onComplete((Handler)responsePromise);
                        }
                    }
                    catch (ODataApplicationException e) {
                        processPromise.fail((Throwable)e);
                    }
                }
            }
        });
        responsePromise.future().onSuccess(finalResultEntities -> {
            entityCollection.getEntities().addAll(finalResultEntities);
            try {
                EdmEntitySet edmEntitySet = NavigationPropertyHelper.chooseEntitySet(resourceParts, uriResourceEntitySet.getEntitySet(), this.routingContext);
                EntityCollectionSerializerOptions opts = this.createSerializerOptions(request, uriInfo, edmEntitySet);
                response.setContent(this.odata.createSerializer(responseFormat).entityCollection(this.serviceMetadata, edmEntityType, (AbstractEntityCollection)entityCollection, opts).getContent());
                response.setStatusCode(HttpStatusCode.OK.getStatusCode());
                response.setHeader("Content-Type", responseFormat.toContentTypeString());
                processPromise.complete();
            }
            catch (ODataException e) {
                processPromise.fail((Throwable)e);
            }
        }).onFailure(arg_0 -> processPromise.fail(arg_0));
    }

    private void applyCountOption(CountOption countOption, List<Entity> filteredEntities, EntityCollection entityCollection) {
        if (countOption != null && countOption.getValue()) {
            entityCollection.setCount(Integer.valueOf(filteredEntities.size()));
        }
    }

    private List<Entity> applyFilterQueryOption(FilterOption filterOption, List<Entity> unfilteredEntities) throws ODataException {
        List<Entity> filteredEntities = unfilteredEntities;
        if (filterOption != null) {
            LOGGER.correlateWith(this.routingContext).debug("Applying filter expression on list of entities with size: {}", unfilteredEntities.size());
            filteredEntities = new ArrayList<Entity>();
            for (Entity entity : unfilteredEntities) {
                FilterExpressionVisitor filterExpressionVisitor = new FilterExpressionVisitor(this.routingContext, entity);
                LOGGER.correlateWith(this.routingContext).debug("filterOption name: {}, filterOption text: {}", filterOption.getName(), filterOption.getText());
                LOGGER.correlateWith(this.routingContext).debug("FilterExpressionVisitor for entity '{}' was created", entity);
                try {
                    if (!Boolean.TRUE.equals(((ExpressionVisitorOperand)filterOption.getExpression().accept((ExpressionVisitor)filterExpressionVisitor)).getValue())) continue;
                    filteredEntities.add(entity);
                }
                catch (ODataApplicationException | ExpressionVisitException e) {
                    LOGGER.correlateWith(this.routingContext).error("Exception in filter evaluation", e);
                    throw e;
                }
            }
            LOGGER.correlateWith(this.routingContext).debug("Filter expression was applied on list of entities and led to a result list of entities with size: {}", filteredEntities.size());
        }
        return filteredEntities;
    }

    private void applyOrderByQueryOption(OrderByOption orderByOption, List<Entity> resultEntityList) throws ODataApplicationException {
        if (orderByOption != null) {
            LOGGER.correlateWith(this.routingContext).debug("orderByOption name: {}, orderByOption text: {}", orderByOption.getName(), orderByOption.getText());
            try {
                OrderExpressionExecutor.executeOrderOption(this.routingContext, orderByOption, resultEntityList);
            }
            catch (Exception e) {
                String message = "Error during processing of orderBy option";
                LOGGER.correlateWith(this.routingContext).error(message);
                throw new ODataApplicationException(message, HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ENGLISH, (Throwable)e);
            }
        }
    }

    private List<Entity> applySkipQueryOption(SkipOption skipOption, List<Entity> resultEntityList) throws ODataApplicationException {
        List<Entity> skipList = resultEntityList;
        if (skipOption != null) {
            LOGGER.correlateWith(this.routingContext).debug("skipOption name: {}, skipOption text: {}, skipOption value: {}", new Object[]{skipOption.getName(), skipOption.getText(), skipOption.getValue()});
            int skipValue = skipOption.getValue();
            if (skipValue >= 0) {
                if (skipValue <= resultEntityList.size()) {
                    skipList = resultEntityList.subList(skipValue, resultEntityList.size());
                } else {
                    skipList.clear();
                }
            } else {
                String message = "Invalid value for $skip";
                LOGGER.correlateWith(this.routingContext).error(message);
                throw new ODataApplicationException(message, HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ENGLISH);
            }
        }
        return skipList;
    }

    private List<Entity> applyTopQueryOption(TopOption topOption, List<Entity> resultEntityList) throws ODataApplicationException {
        List<Entity> topList = resultEntityList;
        if (topOption != null) {
            LOGGER.correlateWith(this.routingContext).debug("topOption name: {}, topOption text: {}, topOption value: {}", new Object[]{topOption.getName(), topOption.getText(), topOption.getValue()});
            int topValue = topOption.getValue();
            if (topValue >= 0) {
                if (topValue <= resultEntityList.size()) {
                    topList = resultEntityList.subList(0, topValue);
                }
            } else {
                throw new ODataApplicationException("Invalid value for $top", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ENGLISH);
            }
        }
        return topList;
    }

    private Future<List<Entity>> applyExpandQueryOptions(UriInfo uriInfo, List<Entity> resultEntityList) {
        return EntityExpander.create(this.vertx, uriInfo.getExpandOption(), this.routingContext).map(expander -> {
            for (Entity requestedEntity : resultEntityList) {
                expander.expand(requestedEntity);
            }
            return resultEntityList;
        });
    }

    private EntityCollectionSerializerOptions createSerializerOptions(ODataRequest request, UriInfo uriInfo, EdmEntitySet edmEntitySet) throws SerializerException {
        String collectionId = request.getRawRequestUri().replaceFirst(request.getRawBaseUri(), "");
        String selectList = this.odata.createUriHelper().buildContextURLSelectList((EdmStructuredType)edmEntitySet.getEntityType(), uriInfo.getExpandOption(), uriInfo.getSelectOption());
        ContextURL contextUrl = ContextURL.with().entitySet(edmEntitySet).selectList(selectList).suffix(ContextURL.Suffix.ENTITY).build();
        return EntityCollectionSerializerOptions.with().id(collectionId).contextURL(contextUrl).select(uriInfo.getSelectOption()).expand(uriInfo.getExpandOption()).count(uriInfo.getCountOption()).build();
    }

    public void countEntityCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo) {
        Promise<Void> processPromise = this.getProcessPromise();
        ProcessorHelper.forwardRequest(request, DataAction.READ, uriInfo, this.vertx, this.routingContext, processPromise).onSuccess(ew -> {
            try {
                List<Entity> resultEntityList = this.applyFilterQueryOption(uriInfo.getFilterOption(), ew.getEntities());
                ByteArrayInputStream serializerContent = new ByteArrayInputStream(String.valueOf(resultEntityList.size()).getBytes(StandardCharsets.UTF_8));
                response.setContent((InputStream)serializerContent);
                response.setHeader("Content-Type", ContentType.TEXT_PLAIN.toContentTypeString());
                response.setStatusCode(HttpStatusCode.OK.getStatusCode());
                processPromise.complete();
            }
            catch (ODataException e) {
                processPromise.fail((Throwable)e);
            }
        });
    }
}

