/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.processor;

import io.neonbee.endpoint.odatav4.internal.olingo.processor.NavigationPropertyHelper;
import io.neonbee.internal.helper.AsyncHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;

public final class EntityExpander {
    private final List<EdmNavigationProperty> navigationProperties;
    private final Map<EdmEntityType, List<Entity>> fetchedEntities;

    private EntityExpander(List<EdmNavigationProperty> navigationProperties, Map<EdmEntityType, List<Entity>> fetchedEntities) {
        this.navigationProperties = navigationProperties;
        this.fetchedEntities = fetchedEntities;
    }

    public static Future<EntityExpander> create(Vertx vertx, ExpandOption expandOption, RoutingContext routingContext) {
        if (expandOption != null) {
            List<EdmNavigationProperty> navigationProperties = EntityExpander.getNavigationProperties(expandOption);
            HashMap fetchedEntities = new HashMap();
            List fetchFutures = navigationProperties.stream().distinct().map(navProb -> NavigationPropertyHelper.fetchReferencedEntities(navProb, vertx, routingContext).map(entities -> fetchedEntities.put(navProb.getType(), entities))).collect(Collectors.toList());
            return AsyncHelper.allComposite(fetchFutures).map(v -> new EntityExpander(navigationProperties, fetchedEntities));
        }
        return Future.succeededFuture((Object)new EntityExpander(List.of(), Map.of()));
    }

    private static List<EdmNavigationProperty> getNavigationProperties(ExpandOption expandOption) {
        return expandOption.getExpandItems().stream().map(item -> (UriResource)item.getResourcePath().getUriResourceParts().get(0)).filter(UriResourceNavigation.class::isInstance).map(UriResourceNavigation.class::cast).map(UriResourceNavigation::getProperty).collect(Collectors.toList());
    }

    public void expand(Entity entityToExpand) {
        for (EdmNavigationProperty navigationProperty : this.navigationProperties) {
            if (!EdmTypeKind.ENTITY.equals((Object)navigationProperty.getType().getKind())) {
                throw new UnsupportedOperationException("At the moment only type Entity can be expanded");
            }
            List<Entity> entitiesToLink = NavigationPropertyHelper.getRelatedEntities(navigationProperty, entityToExpand, this.fetchedEntities.get(navigationProperty.getType()));
            this.linkEntities(entityToExpand, navigationProperty, entitiesToLink);
        }
    }

    private void linkEntities(Entity entity, EdmNavigationProperty navigationProperty, List<Entity> entitiesToLink) {
        Link link = new Link();
        link.setTitle(navigationProperty.getName());
        if (navigationProperty.isCollection()) {
            EntityCollection expandCollection = new EntityCollection();
            expandCollection.getEntities().addAll(entitiesToLink);
            link.setInlineEntitySet(expandCollection);
        } else {
            link.setInlineEntity(entitiesToLink.get(0));
        }
        entity.getNavigationLinks().add(link);
    }
}

