/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.processor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.neonbee.data.DataAction;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.AsynchronousProcessor;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.EntityProcessor;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.ProcessorHelper;
import io.neonbee.entity.EntityWrapper;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceProperty;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_INTERFACE"}, justification="Common practice in Olingo to name the implementation of the processor same as the interface")
public class PrimitiveProcessor
extends AsynchronousProcessor
implements org.apache.olingo.server.api.processor.PrimitiveProcessor {
    private OData odata;
    private ServiceMetadata serviceMetadata;

    public PrimitiveProcessor(Vertx vertx, RoutingContext routingContext, Promise<Void> processPromise) {
        super(vertx, routingContext, processPromise);
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
    }

    public void readPrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        Promise<Void> processPromise = this.getProcessPromise();
        ProcessorHelper.forwardRequest(request, DataAction.READ, uriInfo, this.vertx, this.routingContext, processPromise).onSuccess(this.handleResult(uriInfo, response, responseFormat, processPromise));
    }

    public void updatePrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        throw new UnsupportedOperationException("updatePrimitive not implemented");
    }

    public void deletePrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        throw new UnsupportedOperationException("deletePrimitive not implemented");
    }

    private Handler<EntityWrapper> handleResult(UriInfo uriInfo, ODataResponse response, ContentType responseFormat, Promise<Void> processPromise) {
        return ew -> {
            try {
                UriResourceEntitySet uriEntitySet = (UriResourceEntitySet)uriInfo.getUriResourceParts().get(0);
                Entity entity = EntityProcessor.findEntityByKeyPredicates(this.routingContext, uriEntitySet, ew.getEntities());
                if (entity == null) {
                    processPromise.fail((Throwable)new ODataApplicationException("Entity not found", HttpStatusCode.NOT_FOUND.getStatusCode(), Locale.ENGLISH));
                    return;
                }
                List resourceParts = uriInfo.getUriResourceParts();
                UriResourceProperty uriProperty = (UriResourceProperty)resourceParts.get(resourceParts.size() - 1);
                EdmProperty edmProperty = uriProperty.getProperty();
                String edmPropertyName = edmProperty.getName();
                Property property = entity.getProperty(edmPropertyName);
                if (property == null) {
                    processPromise.fail((Throwable)new ODataApplicationException("Property not found", HttpStatusCode.NOT_FOUND.getStatusCode(), Locale.ENGLISH));
                    return;
                }
                Object value = property.getValue();
                if (value != null) {
                    ContextURL contextUrl = ContextURL.with().entitySet(uriEntitySet.getEntitySet()).navOrPropertyPath(edmPropertyName).build();
                    PrimitiveSerializerOptions options = PrimitiveSerializerOptions.with().contextURL(contextUrl).build();
                    EdmPrimitiveType edmPropertyType = (EdmPrimitiveType)edmProperty.getType();
                    InputStream propertyStream = this.odata.createSerializer(responseFormat).primitive(this.serviceMetadata, edmPropertyType, property, options).getContent();
                    response.setContent(propertyStream);
                    response.setStatusCode(HttpStatusCode.OK.getStatusCode());
                    response.setHeader("Content-Type", responseFormat.toContentTypeString());
                } else {
                    response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
                }
                processPromise.complete();
            }
            catch (Exception e) {
                processPromise.fail((Throwable)e);
            }
        };
    }
}

