/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.processor;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.data.DataAction;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.entity.EntityVerticle;
import io.neonbee.entity.EntityWrapper;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;

public final class ProcessorHelper {
    public static final String RESPONSE_HEADER_PREFIX = "response.";
    public static final String ODATA_FILTER_KEY = "OData.filter";
    public static final String ODATA_ORDER_BY_KEY = "OData.orderby";
    public static final String ODATA_SKIP_KEY = "OData.skip";
    public static final String ODATA_TOP_KEY = "OData.top";
    public static final String ODATA_EXPAND_KEY = "OData.expand";
    public static final String ODATA_KEY_PREDICATE_KEY = "OData.key";

    private ProcessorHelper() {
    }

    private static DataQuery odataRequestToQuery(ODataRequest request, DataAction action, Buffer body) {
        String uriPath = "/" + request.getRawServiceResolutionUri() + request.getRawODataPath();
        String rawQueryPath = request.getRawQueryPath();
        return new DataQuery(action, uriPath, rawQueryPath, request.getAllHeaders(), body).addHeader("X-HTTP-Method", request.getMethod().name());
    }

    public static Future<EntityWrapper> forwardRequest(ODataRequest request, DataAction action, UriInfo uriInfo, Vertx vertx, RoutingContext routingContext, Promise<Void> processPromise) {
        return ProcessorHelper.forwardRequest(request, action, null, uriInfo, vertx, routingContext, processPromise);
    }

    public static Future<EntityWrapper> forwardRequest(ODataRequest request, DataAction action, Entity entity, UriInfo uriInfo, Vertx vertx, RoutingContext routingContext, Promise<Void> processPromise) {
        UriResourceEntitySet uriResourceEntitySet = (UriResourceEntitySet)uriInfo.getUriResourceParts().get(0);
        EdmEntityType entityType = uriResourceEntitySet.getEntitySet().getEntityType();
        Buffer body = Optional.ofNullable(entity).map(e -> new EntityWrapper(entityType.getFullQualifiedName(), (Entity)e).toBuffer(vertx)).orElse(null);
        DataQuery query = ProcessorHelper.odataRequestToQuery(request, action, body);
        DataContextImpl dataContext = new DataContextImpl(routingContext);
        return EntityVerticle.requestEntity(vertx, new DataRequest(entityType.getFullQualifiedName(), query), dataContext).map(result -> {
            ProcessorHelper.transferResponseHint(dataContext, routingContext);
            return result;
        }).onFailure(arg_0 -> processPromise.fail(arg_0));
    }

    @VisibleForTesting
    static void transferResponseHint(DataContext dataContext, RoutingContext routingContext) {
        dataContext.responseData().entrySet().forEach(entry -> routingContext.put(RESPONSE_HEADER_PREFIX + (String)entry.getKey(), entry.getValue()));
    }
}

