/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.raw;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.neonbee.config.EndpointConfig;
import io.neonbee.data.DataAction;
import io.neonbee.data.DataException;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.data.DataVerticle;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.endpoint.Endpoint;
import io.neonbee.internal.RegexBlockList;
import io.neonbee.internal.helper.CollectionHelper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;

public class RawEndpoint
implements Endpoint {
    public static final String CONFIG_EXPOSE_HIDDEN_VERTICLES = "exposeHiddenVerticles";
    public static final String DEFAULT_BASE_PATH = "/raw/";
    private static final Pattern HIDDEN_VERTICLES_PATTERN = Pattern.compile("(?:^|/)(?!.*/)_");

    @Override
    public EndpointConfig getDefaultConfig() {
        return new EndpointConfig().setType(RawEndpoint.class.getName()).setBasePath(DEFAULT_BASE_PATH).setAdditionalConfig(new JsonObject().put(CONFIG_EXPOSE_HIDDEN_VERTICLES, (Object)false));
    }

    @Override
    public Future<Router> createEndpointRouter(Vertx vertx, String basePath, JsonObject config) {
        return Future.succeededFuture((Object)Endpoint.createRouter(vertx, new RawHandler(config)));
    }

    @VisibleForTesting
    static class RawHandler
    implements Handler<RoutingContext> {
        private final boolean exposeHiddenVerticles;
        private final RegexBlockList exposedVerticles;

        RawHandler(JsonObject config) {
            this.exposeHiddenVerticles = config.getBoolean(RawEndpoint.CONFIG_EXPOSE_HIDDEN_VERTICLES, Boolean.valueOf(false));
            this.exposedVerticles = RegexBlockList.fromJson(config.getValue("exposedVerticles"));
        }

        public void handle(RoutingContext routingContext) {
            HttpServerRequest request = routingContext.request();
            DataAction action = this.mapMethodToAction(request.method());
            if (action == null) {
                routingContext.fail(HttpResponseStatus.METHOD_NOT_ALLOWED.code(), (Throwable)new UnsupportedOperationException("HTTP Method is not allowed"));
                return;
            }
            String qualifiedName = RawHandler.determineQualifiedName(routingContext);
            if (Strings.isNullOrEmpty((String)qualifiedName)) {
                routingContext.fail(HttpResponseStatus.BAD_REQUEST.code(), (Throwable)new IllegalArgumentException("Missing the full qualified verticle name"));
                return;
            }
            if (!this.exposeHiddenVerticles && HIDDEN_VERTICLES_PATTERN.matcher(qualifiedName).find() || !this.exposedVerticles.isAllowed(qualifiedName)) {
                routingContext.fail(HttpResponseStatus.NOT_FOUND.code());
                return;
            }
            String decodedQueryPath = null;
            try {
                if (!Strings.isNullOrEmpty((String)request.query())) {
                    decodedQueryPath = URLDecoder.decode(request.query(), StandardCharsets.UTF_8);
                }
            }
            catch (IllegalArgumentException e) {
                routingContext.fail(HttpResponseStatus.BAD_REQUEST.code(), (Throwable)new IllegalArgumentException("Invalid request query"));
                return;
            }
            DataQuery query = new DataQuery(action, Utils.pathOffset((String)routingContext.normalizedPath(), (RoutingContext)routingContext).substring(qualifiedName.length() + 1), decodedQueryPath, CollectionHelper.multiMapToMap(request.headers()), routingContext.body().buffer()).addHeader("X-HTTP-Method", request.method().name());
            DataContextImpl context = new DataContextImpl(routingContext);
            DataVerticle.requestData(routingContext.vertx(), new DataRequest(qualifiedName, query), new DataContextImpl(routingContext)).onComplete(asyncResult -> {
                if (asyncResult.failed()) {
                    Throwable cause = asyncResult.cause();
                    if (cause instanceof DataException) {
                        switch (((DataException)cause).failureCode()) {
                            case 1010: {
                                routingContext.fail(HttpResponseStatus.NOT_FOUND.code());
                                return;
                            }
                            case 1020: {
                                routingContext.fail(HttpResponseStatus.GATEWAY_TIMEOUT.code());
                                return;
                            }
                        }
                    }
                    routingContext.fail(-1, cause);
                    return;
                }
                Object result = asyncResult.result();
                if (result == null) {
                    routingContext.response().setStatusCode((action == DataAction.CREATE ? HttpResponseStatus.CREATED : HttpResponseStatus.NO_CONTENT).code()).end();
                    return;
                }
                HttpServerResponse response = routingContext.response().putHeader("Content-Type", Optional.ofNullable(context.responseData().get("Content-Type")).map(String.class::cast).orElse("application/json"));
                if (result instanceof JsonObject) {
                    result = ((JsonObject)result).toBuffer();
                } else if (result instanceof JsonArray) {
                    result = ((JsonArray)result).toBuffer();
                } else if (!(result instanceof Buffer)) {
                    result = Json.encodeToBuffer((Object)asyncResult.result());
                } else {
                    response.putHeader("Content-Type", "text/plain");
                }
                response.end((Buffer)result);
            });
        }

        @VisibleForTesting
        static String determineQualifiedName(RoutingContext routingContext) {
            String routingPath = Utils.pathOffset((String)routingContext.normalizedPath(), (RoutingContext)routingContext);
            int routingPathLength = routingPath.length();
            int nextForwardSlash = 0;
            while ((nextForwardSlash = routingPath.indexOf(47, nextForwardSlash)) != -1 && ++nextForwardSlash != routingPathLength) {
                char firstCharacter = routingPath.charAt(nextForwardSlash);
                if ('_' != firstCharacter && !Character.isUpperCase(firstCharacter)) continue;
                return routingPath.substring(1, nextForwardSlash).toLowerCase(Locale.ROOT) + routingPath.substring(nextForwardSlash).split("/", 2)[0];
            }
            return null;
        }

        private DataAction mapMethodToAction(HttpMethod method) {
            if (HttpMethod.POST.equals((Object)method)) {
                return DataAction.CREATE;
            }
            if (HttpMethod.HEAD.equals((Object)method) || HttpMethod.GET.equals((Object)method)) {
                return DataAction.READ;
            }
            if (HttpMethod.PUT.equals((Object)method) || HttpMethod.PATCH.equals((Object)method)) {
                return DataAction.UPDATE;
            }
            if (HttpMethod.DELETE.equals((Object)method)) {
                return DataAction.DELETE;
            }
            return null;
        }
    }
}

