/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.entity;

import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsModel;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class EntityModelDefinition {
    public static final String CSN = ".csn";
    public static final String EDMX = ".edmx";
    private final Map<String, byte[]> csnModelDefinitions;
    private final Map<String, byte[]> associatedModelDefinitions;

    public EntityModelDefinition(Map<String, byte[]> csnModelDefinitions, Map<String, byte[]> associatedModelDefinitions) {
        this.csnModelDefinitions = Objects.requireNonNull(csnModelDefinitions);
        this.associatedModelDefinitions = Objects.requireNonNull(associatedModelDefinitions);
    }

    public Map<String, byte[]> getCSNModelDefinitions() {
        return this.csnModelDefinitions;
    }

    public Map<String, byte[]> getAssociatedModelDefinitions() {
        return this.associatedModelDefinitions;
    }

    public String toString() {
        return String.join((CharSequence)",", this.csnModelDefinitions.keySet()) + "$" + String.join((CharSequence)",", this.associatedModelDefinitions.keySet());
    }

    public static String getNamespace(CdsModel csnModel) {
        return csnModel.services().findAny().map(CdsDefinition::getQualifiedName).map(name -> {
            int lastIndexOf = name.lastIndexOf(46);
            return lastIndexOf == -1 ? "" : name.substring(0, lastIndexOf);
        }).orElseThrow(() -> new RuntimeException("No service found in CDS model!"));
    }

    public static String retrieveNamespace(String qualifiedServiceName) {
        int lastIndexOf = qualifiedServiceName.lastIndexOf(46);
        return lastIndexOf == -1 ? "" : qualifiedServiceName.substring(0, lastIndexOf);
    }

    public static List<Path> resolveEdmxPaths(Path csnPath, CdsModel cdsModel) {
        return cdsModel.services().map(service -> {
            String qualifiedName = service.getQualifiedName();
            String edmxFileName = qualifiedName + EDMX;
            return csnPath.getParent().resolve(edmxFileName);
        }).collect(Collectors.toList());
    }
}

