/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.sap.cds.reflect.CdsModel;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeOptions;
import io.neonbee.entity.EntityModel;
import io.neonbee.entity.EntityModelDefinition;
import io.neonbee.entity.EntityModelManager;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.internal.helper.BufferHelper;
import io.neonbee.internal.helper.FileSystemHelper;
import io.neonbee.internal.scanner.ClassPathScanner;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystemException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.etag.ServiceMetadataETagSupport;
import org.apache.olingo.server.core.MetadataParser;
import org.apache.olingo.server.core.SchemaBasedEdmProvider;

class EntityModelLoader {
    @VisibleForTesting
    static final String NEONBEE_MODELS = "NeonBee-Models";
    private static final LoggingFacade LOGGER = LoggingFacade.create(EntityModelLoader.class);
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_128();
    private static final PathMatcher MODELS_PATH_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.csn");
    @VisibleForTesting
    Map<String, EntityModel> models = new HashMap<String, EntityModel>();
    @VisibleForTesting
    Map<String, SchemaBasedEdmProvider> edmProviders = new HashMap<String, SchemaBasedEdmProvider>();
    @VisibleForTesting
    Map<String, MetadataParser> metadataParsers = new HashMap<String, MetadataParser>();
    private final Vertx vertx;

    @VisibleForTesting
    EntityModelLoader(Vertx vertx) {
        this.vertx = vertx;
    }

    public static Future<Map<String, EntityModel>> load(Vertx vertx) {
        return new EntityModelLoader(vertx).loadModelsFromModelDirectoryAndClassPath().map(EntityModelLoader::getModels);
    }

    public static Future<Map<String, EntityModel>> load(Vertx vertx, Collection<EntityModelDefinition> definitions) {
        return new EntityModelLoader(vertx).loadModelsFromModelDirectoryAndClassPath().compose(loader -> CompositeFuture.all(definitions.stream().map(loader::loadModelsFromDefinition).collect(Collectors.toList())).map(loader)).map(EntityModelLoader::getModels);
    }

    public Map<String, EntityModel> getModels() {
        return this.models;
    }

    public Future<EntityModelLoader> loadModelsFromModelDirectoryAndClassPath() {
        NeonBeeOptions options = NeonBee.get(this.vertx).getOptions();
        return CompositeFuture.all(this.scanDir(options.getModelsDirectory()), options.shouldIgnoreClassPath() ? Future.succeededFuture() : this.scanClassPath()).map((Object)this);
    }

    public Future<EntityModelLoader> loadModelsFromDefinition(EntityModelDefinition definition) {
        return AsyncHelper.allComposite(definition.getCSNModelDefinitions().entrySet().stream().map(entry -> this.parseModel((String)entry.getKey(), (byte[])entry.getValue(), definition.getAssociatedModelDefinitions())).collect(Collectors.toList())).map((Object)this);
    }

    @VisibleForTesting
    Future<Void> scanDir(Path path) {
        return FileSystemHelper.readDir(this.vertx, path).recover(throwable -> throwable instanceof FileSystemException && throwable.getMessage().contains("Does not exist") ? Future.succeededFuture(Collections.emptyList()) : Future.failedFuture((Throwable)throwable)).compose(files -> CompositeFuture.all(files.stream().map(file -> FileSystemHelper.isDirectory(this.vertx, file).compose(isDir -> isDir != false ? this.scanDir((Path)file) : this.loadModel((Path)file))).collect(Collectors.toList()))).compose(future -> Future.succeededFuture());
    }

    @VisibleForTesting
    Future<Void> scanClassPath() {
        LOGGER.info("Loading models from class path");
        ClassPathScanner scanner = new ClassPathScanner();
        Future<List<String>> csnFiles = scanner.scanWithPredicate(this.vertx, name -> name.endsWith(".csn"));
        Future<List<String>> modelFiles = scanner.scanManifestFiles(this.vertx, NEONBEE_MODELS);
        return CompositeFuture.all(csnFiles, modelFiles).compose(scanResult -> CompositeFuture.all(Streams.concat((Stream[])new Stream[]{((List)csnFiles.result()).stream(), ((List)modelFiles.result()).stream()}).distinct().map(name -> this.loadModel(Path.of(name, new String[0])).otherwise(throwable -> {
            LOGGER.warn("Loading model {} from class path failed", throwable, name);
            return null;
        })).collect(Collectors.toList()))).mapEmpty();
    }

    Future<Void> loadModel(Path csnFile) {
        if (!MODELS_PATH_MATCHER.matches(csnFile)) {
            return Future.succeededFuture();
        }
        return this.readCsnModel(csnFile).compose(cdsModel -> CompositeFuture.all(EntityModelDefinition.resolveEdmxPaths(csnFile, cdsModel).stream().map(this::loadEdmxModel).collect(Collectors.toList())).onSuccess(compositeFuture -> this.buildModelMap((CdsModel)cdsModel, compositeFuture.list()))).mapEmpty();
    }

    Future<Void> parseModel(String csnFile, byte[] csnPayload, Map<String, byte[]> associatedModels) {
        return this.parseCsnModel(csnPayload).compose(cdsModel -> CompositeFuture.all(EntityModelDefinition.resolveEdmxPaths(Path.of(csnFile, new String[0]), cdsModel).stream().map(Path::toString).map(path -> (byte[])FileSystemHelper.getPathFromMap(associatedModels, path)).map(this::parseEdmxModel).collect(Collectors.toList())).onSuccess(compositeFuture -> this.buildModelMap((CdsModel)cdsModel, compositeFuture.list()))).mapEmpty();
    }

    private void buildModelMap(CdsModel cdsModel, List<ServiceMetadata> edmxModels) {
        Map<String, ServiceMetadata> edmxMap = edmxModels.stream().collect(Collectors.toMap(serviceMetaData -> serviceMetaData.getEdm().getEntityContainer().getNamespace(), Function.identity()));
        EntityModel entityModel = EntityModel.of(cdsModel, edmxMap);
        String namespace = EntityModelDefinition.getNamespace(cdsModel);
        this.models.put(namespace, entityModel);
        LOGGER.info("Entity model of model with schema namespace {} was added the entity model map.", namespace);
    }

    @VisibleForTesting
    Future<CdsModel> readCsnModel(Path file) {
        return FileSystemHelper.readFile(this.vertx, file).map(Buffer::getBytes).compose(this::parseCsnModel);
    }

    @VisibleForTesting
    Future<CdsModel> parseCsnModel(byte[] csnModel) {
        return AsyncHelper.executeBlocking(this.vertx, () -> {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(csnModel);){
                CdsModel cdsModel = CdsModel.read((InputStream)inputStream);
                return cdsModel;
            }
        });
    }

    Future<ServiceMetadata> loadEdmxModel(Path file) {
        return FileSystemHelper.readFile(this.vertx, file).compose(this::createServiceMetadataWithSchema);
    }

    Future<ServiceMetadata> parseEdmxModel(byte[] payload) {
        return Future.succeededFuture((Object)Buffer.buffer((byte[])payload)).compose(this::createServiceMetadataWithSchema);
    }

    private Future<ServiceMetadata> createServiceMetadataWithSchema(Buffer csdl) {
        return AsyncHelper.executeBlocking(this.vertx, () -> {
            ServiceMetadata serviceMetadata = EntityModelLoader.createServiceMetadata(csdl);
            String schemaNamespace = ((EdmSchema)serviceMetadata.getEdm().getSchemas().get(0)).getNamespace();
            return this.createServiceMetadataWithSchema(csdl, schemaNamespace);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceMetadata createServiceMetadataWithSchema(Buffer csdl, String schemaNamespace) throws XMLStreamException {
        EntityModelLoader entityModelLoader = this;
        synchronized (entityModelLoader) {
            MetadataParser parser = this.metadataParsers.computeIfAbsent(schemaNamespace, newSchemaNamespace -> new MetadataParser().referenceResolver(null).parseAnnotations(true));
            InputStreamReader csdlReader = new InputStreamReader((InputStream)new BufferHelper.BufferInputStream(csdl), StandardCharsets.UTF_8);
            SchemaBasedEdmProvider provider = this.edmProviders.get(schemaNamespace);
            if (provider == null) {
                provider = parser.buildEdmProvider((Reader)csdlReader);
                this.edmProviders.put(schemaNamespace, provider);
            } else {
                parser.addToEdmProvider(provider, (Reader)csdlReader);
            }
            return EntityModelManager.getBufferedOData().createServiceMetadata((CsdlEdmProvider)provider, Collections.emptyList(), (ServiceMetadataETagSupport)new MetadataETagSupport(csdl));
        }
    }

    private static ServiceMetadata createServiceMetadata(Buffer csdl) throws XMLStreamException {
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferHelper.BufferInputStream(csdl), StandardCharsets.UTF_8);
        SchemaBasedEdmProvider edmProvider = new MetadataParser().referenceResolver(null).buildEdmProvider((Reader)reader);
        return EntityModelManager.getBufferedOData().createServiceMetadata((CsdlEdmProvider)edmProvider, Collections.emptyList());
    }

    @VisibleForTesting
    static class MetadataETagSupport
    implements ServiceMetadataETagSupport {
        private final String metadataETag;
        private final String serviceDocumentETag;

        MetadataETagSupport(Buffer csdl) {
            this.metadataETag = this.serviceDocumentETag = MetadataETagSupport.generateMetadataETag(csdl);
        }

        public String getMetadataETag() {
            return this.metadataETag;
        }

        public String getServiceDocumentETag() {
            return this.serviceDocumentETag;
        }

        private static String generateMetadataETag(Buffer csdl) {
            return "\"" + HASH_FUNCTION.newHasher().putUnencodedChars((CharSequence)csdl.toString()).hash().toString() + "\"";
        }
    }
}

