/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import io.neonbee.NeonBee;
import io.neonbee.entity.EntityModel;
import io.neonbee.entity.EntityModelDefinition;
import io.neonbee.entity.EntityModelLoader;
import io.neonbee.internal.SharedDataAccessor;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.shareddata.Lock;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.olingo.server.api.OData;

public class EntityModelManager {
    public static final String EVENT_BUS_MODELS_LOADED_ADDRESS = EntityModelManager.class.getSimpleName() + "Loaded";
    private static final ThreadLocal<OData> THREAD_LOCAL_ODATA = ThreadLocal.withInitial(OData::newInstance);
    private static final DeliveryOptions LOCAL_DELIVERY = new DeliveryOptions().setLocalOnly(true);
    @Deprecated(forRemoval=true)
    private static final Map<NeonBee, Map<String, EntityModelDefinition>> EXTERNAL_MODEL_IDENTIFIERS = new WeakHashMap<NeonBee, Map<String, EntityModelDefinition>>();
    @VisibleForTesting
    Map<String, EntityModel> bufferedModels;
    @VisibleForTesting
    final Set<EntityModelDefinition> externalModelDefinitions = ConcurrentHashMap.newKeySet();
    @VisibleForTesting
    final NeonBee neonBee;

    public EntityModelManager(NeonBee neonBee) {
        if (neonBee.getModelManager() != null) {
            throw new IllegalArgumentException("The passed NeonBee instance already has a EntityModelManager. Use neonBee.getModelManager() instead of creating a new EntityModelManager");
        }
        this.neonBee = neonBee;
    }

    public static OData getBufferedOData() {
        return THREAD_LOCAL_ODATA.get();
    }

    @Deprecated(forRemoval=true)
    public static Map<String, EntityModel> getBufferedModels(Vertx vertx) {
        return EntityModelManager.getBufferedModels(NeonBee.get(vertx));
    }

    @Deprecated(forRemoval=true)
    public static Map<String, EntityModel> getBufferedModels(NeonBee neonBee) {
        return neonBee.getModelManager().getBufferedModels();
    }

    public Map<String, EntityModel> getBufferedModels() {
        return this.bufferedModels;
    }

    @Deprecated(forRemoval=true)
    public static EntityModel getBufferedModel(Vertx vertx, String schemaNamespace) {
        return EntityModelManager.getBufferedModel(NeonBee.get(vertx), schemaNamespace);
    }

    @Deprecated(forRemoval=true)
    public static EntityModel getBufferedModel(NeonBee neonBee, String schemaNamespace) {
        return neonBee.getModelManager().getBufferedModel(schemaNamespace);
    }

    public EntityModel getBufferedModel(String schemaNamespace) {
        return this.bufferedModels != null ? this.bufferedModels.get(schemaNamespace) : null;
    }

    @Deprecated(forRemoval=true)
    public static Future<Map<String, EntityModel>> getSharedModels(Vertx vertx) {
        return EntityModelManager.getSharedModels(NeonBee.get(vertx));
    }

    @Deprecated(forRemoval=true)
    public static Future<Map<String, EntityModel>> getSharedModels(NeonBee neonBee) {
        return neonBee.getModelManager().getSharedModels();
    }

    public Future<Map<String, EntityModel>> getSharedModels() {
        Map<String, EntityModel> models = this.getBufferedModels();
        if (models != null) {
            return Future.succeededFuture(models);
        }
        return new SharedDataAccessor(this.neonBee.getVertx(), EntityModelManager.class).getLocalLock().transform(asyncLocalLock -> {
            Map<String, EntityModel> retryModels = this.getBufferedModels();
            if (retryModels != null) {
                if (asyncLocalLock.succeeded()) {
                    ((Lock)asyncLocalLock.result()).release();
                }
                return Future.succeededFuture(retryModels);
            }
            return this.reloadModels().onComplete(loadedModels -> {
                if (asyncLocalLock.succeeded()) {
                    ((Lock)asyncLocalLock.result()).release();
                }
            });
        });
    }

    @Deprecated(forRemoval=true)
    public static Future<EntityModel> getSharedModel(Vertx vertx, String schemaNamespace) {
        return EntityModelManager.getSharedModel(NeonBee.get(vertx), schemaNamespace);
    }

    @Deprecated(forRemoval=true)
    public static Future<EntityModel> getSharedModel(NeonBee neonBee, String schemaNamespace) {
        return neonBee.getModelManager().getSharedModel(schemaNamespace);
    }

    public Future<EntityModel> getSharedModel(String schemaNamespace) {
        return this.getSharedModels().compose(models -> {
            EntityModel model = (EntityModel)models.get(schemaNamespace);
            return model != null ? Future.succeededFuture((Object)model) : Future.failedFuture((Throwable)new NoSuchElementException("Cannot find data model for schema namespace " + schemaNamespace));
        });
    }

    @Deprecated(forRemoval=true)
    public static Future<Map<String, EntityModel>> reloadModels(Vertx vertx) {
        return EntityModelManager.reloadModels(NeonBee.get(vertx));
    }

    @Deprecated(forRemoval=true)
    public static Future<Map<String, EntityModel>> reloadModels(NeonBee neonBee) {
        return neonBee.getModelManager().reloadModels();
    }

    public Future<Map<String, EntityModel>> reloadModels() {
        return EntityModelLoader.load(this.neonBee.getVertx(), this.externalModelDefinitions).onSuccess(models -> {
            this.bufferedModels = Collections.unmodifiableMap(models);
            this.neonBee.getVertx().eventBus().publish(EVENT_BUS_MODELS_LOADED_ADDRESS, null, LOCAL_DELIVERY);
        }).map((Function)Functions.forSupplier(() -> this.bufferedModels));
    }

    @Deprecated(forRemoval=true)
    public static Future<Map<String, EntityModel>> registerModels(Vertx vertx, String modelIdentifier, Map<String, byte[]> csnModelDefinitions, Map<String, byte[]> associatedModelDefinitions) {
        return EntityModelManager.registerModels(NeonBee.get(vertx), EXTERNAL_MODEL_IDENTIFIERS.computeIfAbsent(NeonBee.get(vertx), (Function<NeonBee, Map<String, EntityModelDefinition>>)Functions.forSupplier(ConcurrentHashMap::new)).computeIfAbsent(modelIdentifier, newIdentifier -> new EntityModelDefinition(csnModelDefinitions, associatedModelDefinitions)));
    }

    @Deprecated(forRemoval=true)
    public static Future<Map<String, EntityModel>> registerModels(NeonBee neonBee, EntityModelDefinition modelDefinition) {
        return neonBee.getModelManager().registerModels(modelDefinition);
    }

    public Future<Map<String, EntityModel>> registerModels(EntityModelDefinition modelDefinition) {
        return this.externalModelDefinitions.add(modelDefinition) ? this.reloadModels() : this.getSharedModels();
    }

    @Deprecated(forRemoval=true)
    public static Future<Map<String, EntityModel>> unregisterModels(Vertx vertx, String modelIdentifier) {
        NeonBee neonBee = NeonBee.get(vertx);
        Map<String, EntityModelDefinition> identifiers = EXTERNAL_MODEL_IDENTIFIERS.get(neonBee);
        return identifiers != null ? EntityModelManager.unregisterModels(neonBee, identifiers.get(modelIdentifier)) : EntityModelManager.getSharedModels(neonBee);
    }

    @Deprecated(forRemoval=true)
    public static Future<Map<String, EntityModel>> unregisterModels(NeonBee neonBee, EntityModelDefinition modelDefinition) {
        return neonBee.getModelManager().unregisterModels(modelDefinition);
    }

    public Future<Map<String, EntityModel>> unregisterModels(EntityModelDefinition modelDefinition) {
        return this.externalModelDefinitions.remove(modelDefinition) ? this.reloadModels() : this.getSharedModels();
    }
}

