/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.entity;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.NeonBee;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.data.DataVerticle;
import io.neonbee.entity.EntityModelDefinition;
import io.neonbee.entity.EntityModelManager;
import io.neonbee.entity.EntityWrapper;
import io.neonbee.internal.SharedDataAccessor;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.internal.verticle.ConsolidationVerticle;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.shareddata.AsyncMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.core.uri.parser.Parser;

public abstract class EntityVerticle
extends DataVerticle<EntityWrapper> {
    @VisibleForTesting
    static final String SHARED_ENTITY_MAP_NAME = "entityVerticles[%s]";
    @VisibleForTesting
    static final int SERVICE_NAMESPACE_GROUP = 1;
    @VisibleForTesting
    static final int CDS_NAMESPACE_GROUP = 2;
    @VisibleForTesting
    static final int CDS_SERVICE_NAME_GROUP = 3;
    @VisibleForTesting
    static final int ENTITY_PATH_GROUP = 4;
    @VisibleForTesting
    static final int ENTITY_SET_NAME_GROUP = 5;
    @VisibleForTesting
    static final int ENTITY_PROPERTY_NAME_GROUP = 6;
    @VisibleForTesting
    static final Pattern URI_PATH_PATTERN = Pattern.compile("^/*((?:(.*)\\.)?(.*?))/(([A-Za-z_]\\w+).*?)(?:(?<=\\))/(.*))?$");
    private static final LoggingFacade LOGGER = LoggingFacade.create();

    public Future<EntityWrapper> requestEntity(DataRequest request, DataContext context) {
        return EntityVerticle.requestEntity(this.getVertx(), request, context);
    }

    public static Future<EntityWrapper> requestEntity(Vertx vertx, DataRequest request, DataContext context) {
        FullQualifiedName entityTypeName = request.getEntityTypeName();
        if (entityTypeName == null) {
            throw new IllegalArgumentException("A entity request must specify an entity type name to request data from");
        }
        return EntityVerticle.getVerticlesForEntityType(vertx, entityTypeName).compose(qualifiedNames -> {
            if (qualifiedNames.isEmpty()) {
                return Future.failedFuture((String)"No verticle registered listening to this entity type name");
            }
            if (qualifiedNames.size() == 1) {
                return EntityVerticle.requestData(vertx, new DataRequest((String)qualifiedNames.get(0), request.getQuery()), context);
            }
            DataQuery query = request.getQuery().copy().setHeader("entityTypeName", entityTypeName.getFullQualifiedNameAsString());
            return EntityVerticle.requestData(vertx, new DataRequest(ConsolidationVerticle.QUALIFIED_NAME, query).setLocalOnly(true), context);
        }).compose(entity -> entity instanceof EntityWrapper ? Future.succeededFuture((Object)((EntityWrapper)entity)) : Future.failedFuture((String)"The result of entity verticle must be an EntityWrapper"));
    }

    protected Future<UriInfo> parseUriInfo(DataQuery query) {
        return EntityVerticle.parseUriInfo(this.vertx, query);
    }

    protected static Future<UriInfo> parseUriInfo(Vertx vertx, DataQuery query) {
        return EntityVerticle.parseUriInfo(NeonBee.get(vertx), query);
    }

    protected static Future<UriInfo> parseUriInfo(NeonBee neonBee, DataQuery query) {
        Matcher uriMatcher = URI_PATH_PATTERN.matcher(query.getUriPath());
        if (!uriMatcher.find()) {
            return Future.failedFuture((String)("Failed to match the URI path " + query.getUriPath() + " for an OData URI, the path must at least contain one forward slash to separate the service by the entity set name"));
        }
        String serviceName = uriMatcher.group(1);
        return neonBee.getModelManager().getSharedModel(EntityModelDefinition.retrieveNamespace(serviceName)).compose(entityModel -> AsyncHelper.executeBlocking(neonBee.getVertx(), () -> new Parser(entityModel.getEdmxMetadata(serviceName).getEdm(), EntityModelManager.getBufferedOData()).parseUri(uriMatcher.group(4), query.getQuery(), "", "")));
    }

    public static Future<List<String>> getVerticlesForEntityType(Vertx vertx, FullQualifiedName entityTypeName) {
        return Future.future(asyncGet -> NeonBee.get(vertx).getAsyncMap().get((Object)EntityVerticle.sharedEntityMapName(entityTypeName), (Handler)asyncGet)).map(qualifiedNames -> Optional.ofNullable((JsonArray)qualifiedNames).orElse(new JsonArray()).getList().stream().map(Object::toString).distinct().collect(Collectors.toList()));
    }

    static String sharedEntityMapName(FullQualifiedName entityTypeName) {
        return String.format(SHARED_ENTITY_MAP_NAME, entityTypeName.getFullQualifiedNameAsString());
    }

    @Override
    public final String getName() {
        return String.format("_%s-%d", this.getClass().getSimpleName(), this.getClass().getName().hashCode());
    }

    public abstract Future<Set<FullQualifiedName>> entityTypeNames();

    @Override
    public void start(Promise<Void> promise) {
        this.vertx.eventBus().consumer(EntityModelManager.EVENT_BUS_MODELS_LOADED_ADDRESS, message -> this.announceEntityVerticle(this.vertx).onFailure(throwable -> {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Updating announcements of entity verticle {} failed", this.getQualifiedName(), throwable);
            }
        }));
        this.announceEntityVerticle(this.vertx).compose(nothing -> Future.future(x$0 -> super.start((Promise<Void>)x$0))).onComplete(promise);
    }

    private Future<Void> announceEntityVerticle(Vertx vertx) {
        return this.entityTypeNames().map(entityTypeNames -> entityTypeNames != null ? entityTypeNames : Set.of()).compose(entityTypeNames -> {
            AsyncMap<String, Object> sharedMap = NeonBee.get(vertx).getAsyncMap();
            List announceFutures = entityTypeNames.stream().map(EntityVerticle::sharedEntityMapName).map(name -> {
                LOGGER.debug("Acquire lock {} for announcement of entity verticle", name);
                return new SharedDataAccessor(vertx, EntityVerticle.class).getLock((String)name).onFailure(throwable -> LOGGER.error("Error acquiring lock with name {}", name, throwable)).compose(lock -> sharedMap.get(name).compose(qualifiedNamesOrNull -> {
                    JsonArray qualifiedNames;
                    String qualifiedName = this.getQualifiedName();
                    JsonArray jsonArray = qualifiedNames = qualifiedNamesOrNull != null ? (JsonArray)qualifiedNamesOrNull : new JsonArray();
                    if (!qualifiedNames.contains((Object)qualifiedName)) {
                        qualifiedNames.add((Object)qualifiedName);
                    }
                    LOGGER.info("Announce entity {} is served by entity verticle with qualified name {}", name, qualifiedName);
                    return sharedMap.put(name, (Object)qualifiedNames);
                }).onComplete(anyResult -> {
                    LOGGER.debug("Releasing lock {}", name);
                    lock.release();
                }));
            }).collect(Collectors.toList());
            return AsyncHelper.allComposite(announceFutures).mapEmpty();
        });
    }
}

