/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.health;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.NeonBee;
import io.neonbee.health.HealthCheckException;
import io.neonbee.health.HealthCheckRegistry;
import io.neonbee.health.internal.HealthCheck;
import io.neonbee.internal.helper.ConfigHelper;
import io.neonbee.internal.json.ImmutableJsonObject;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.CheckResult;
import io.vertx.ext.healthchecks.Status;
import java.util.function.Function;

public abstract class AbstractHealthCheck
implements HealthCheck {
    @VisibleForTesting
    static final long DEFAULT_RETENTION_TIME = 0L;
    @VisibleForTesting
    static final ImmutableJsonObject DEFAULT_HEALTH_CHECK_CONFIG = new ImmutableJsonObject(new JsonObject().put("enabled", (Object)true));
    @VisibleForTesting
    JsonObject config;
    private final NeonBee neonBee;

    public AbstractHealthCheck(NeonBee neonBee) {
        this.neonBee = neonBee;
        this.config = DEFAULT_HEALTH_CHECK_CONFIG.mutableCopy();
    }

    public abstract Function<NeonBee, Handler<Promise<Status>>> createProcedure();

    @Override
    public long getRetentionTime() {
        return 0L;
    }

    @Override
    public Future<CheckResult> result() {
        return Future.failedFuture((Throwable)new HealthCheckException("Abstract health check must be registered in a health check registry, first."));
    }

    public Future<HealthCheck> register(HealthCheckRegistry registry) {
        return this.mergeHealthCheckConfig().compose(c -> {
            try {
                return Future.succeededFuture((Object)(this.isGlobal() ? registry.registerGlobalCheck(this.getId(), this.getRetentionTime(), this.createProcedure(), c.copy()) : registry.registerNodeCheck(this.getId(), this.getRetentionTime(), this.createProcedure(), c.copy())));
            }
            catch (HealthCheckException e) {
                return Future.failedFuture((Throwable)e);
            }
        });
    }

    public JsonObject getConfig() {
        return this.config.copy();
    }

    @VisibleForTesting
    Future<JsonObject> mergeHealthCheckConfig() {
        return ConfigHelper.readConfig(this.neonBee.getVertx(), this.getClass().getName()).onSuccess(configFromFile -> this.config.mergeIn(configFromFile)).transform(v -> Future.succeededFuture((Object)this.config));
    }
}

