/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.health;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.NeonBee;
import io.neonbee.health.AbstractHealthCheck;
import io.neonbee.logging.LoggingFacade;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.Status;
import java.util.function.Function;

public class EventLoopHealthCheck
extends AbstractHealthCheck {
    public static final String NAME = "eventloop.utilization";
    @VisibleForTesting
    static final String CRITICAL_EVENT_LOOP_SIZE_KEY = "criticalEventLoopSize";
    private static final int DEFAULT_CRITICAL_EVENT_LOOP_SIZE = 5;
    private static final LoggingFacade LOGGER = LoggingFacade.create();

    public EventLoopHealthCheck(NeonBee neonBee) {
        super(neonBee);
    }

    @Override
    public String getId() {
        return NAME;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public Function<NeonBee, Handler<Promise<Status>>> createProcedure() {
        return nb -> healthCheckPromise -> {
            int threshold = this.config.getInteger(CRITICAL_EVENT_LOOP_SIZE_KEY, Integer.valueOf(5));
            JsonObject criticalEventLoops = this.getCriticalEventLoops((NeonBee)nb, threshold);
            healthCheckPromise.complete((Object)new Status().setOk(criticalEventLoops.isEmpty()).setData(new JsonObject().put("blockedEventLoops", (Object)criticalEventLoops)));
        };
    }

    private JsonObject getCriticalEventLoops(NeonBee neonBee, int threshold) {
        JsonObject busyEventLoops = new JsonObject();
        for (EventExecutor elg : neonBee.getVertx().nettyEventLoopGroup()) {
            SingleThreadEventExecutor singleEventExecutor = (SingleThreadEventExecutor)elg;
            if (singleEventExecutor.pendingTasks() <= threshold) continue;
            busyEventLoops.put(singleEventExecutor.threadProperties().name(), (Object)singleEventExecutor.pendingTasks());
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("[{}] Pending Tasks of \"{}\": {}", new Object[]{neonBee.getNodeId(), singleEventExecutor.threadProperties().name(), singleEventExecutor.pendingTasks()});
        }
        return busyEventLoops;
    }
}

