/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.health;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.NeonBee;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataRequest;
import io.neonbee.data.DataVerticle;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.health.AbstractHealthCheck;
import io.neonbee.health.HealthCheckException;
import io.neonbee.health.internal.HealthCheck;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.CheckResult;
import io.vertx.ext.healthchecks.HealthChecks;
import io.vertx.ext.healthchecks.Status;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HealthCheckRegistry {
    private static final String UP = "UP";
    private static final String DOWN = "DOWN";
    private static final String ID_KEY = "id";
    private static final String CHECKS_KEY = "checks";
    private static final String STATUS_KEY = "status";
    private static final String OUTCOME_KEY = "outcome";
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    @VisibleForTesting
    HealthChecks healthChecks;
    @VisibleForTesting
    final Map<String, HealthCheck> checks;
    private final Vertx vertx;

    public HealthCheckRegistry(Vertx vertx) {
        this.vertx = vertx;
        this.checks = new HashMap<String, HealthCheck>();
        this.healthChecks = HealthChecks.create((Vertx)vertx);
    }

    public Map<String, HealthCheck> getHealthChecks() {
        return Collections.unmodifiableMap(this.checks);
    }

    public HealthCheck registerGlobalCheck(String id, long retentionTime, Function<NeonBee, Handler<Promise<Status>>> procedure, JsonObject config) throws HealthCheckException {
        return this.register(id, retentionTime, true, procedure, config);
    }

    public HealthCheck registerNodeCheck(String id, long retentionTime, Function<NeonBee, Handler<Promise<Status>>> procedure, JsonObject config) throws HealthCheckException {
        String nodePrefix = "node." + NeonBee.get(this.vertx).getNodeId().strip() + ".";
        return this.register(nodePrefix + id, retentionTime, false, procedure, config);
    }

    public Future<HealthCheck> register(AbstractHealthCheck healthCheck) {
        return healthCheck.register(this);
    }

    public void unregister(HealthCheck healthCheck) {
        this.unregister(healthCheck.getId());
    }

    public void unregister(String id) {
        this.healthChecks.unregister(id);
        this.checks.remove(id);
    }

    public Future<JsonObject> collectHealthCheckResults() {
        return this.collectHealthCheckResults(new DataContextImpl());
    }

    public Future<JsonObject> collectHealthCheckResults(DataContext dataContext) {
        Future<List<JsonObject>> asyncResults = NeonBee.get(this.vertx).getOptions().isClustered() ? this.getClusteredHealthCheckResults(dataContext) : this.getLocalHealthCheckResults();
        return asyncResults.map(results -> this.consolidateResults((List<JsonObject>)results, dataContext)).onFailure(t -> LOGGER.correlateWith(dataContext).error("Could not consolidate health check information"));
    }

    @VisibleForTesting
    Future<List<JsonObject>> getLocalHealthCheckResults() {
        List asyncCheckResults = this.getHealthChecks().values().stream().map(hc -> hc.result().map(CheckResult::toJson)).collect(Collectors.toList());
        return AsyncHelper.joinComposite(asyncCheckResults).transform(v -> {
            List allSucceeded = asyncCheckResults.stream().filter(Future::succeeded).map(Future::result).peek(result -> result.remove(OUTCOME_KEY)).collect(Collectors.toList());
            return Future.succeededFuture(allSucceeded);
        });
    }

    private Future<List<JsonObject>> getClusteredHealthCheckResults(DataContext dataContext) {
        return NeonBee.get(this.vertx).getAsyncMap().get((Object)"healthCheckVerticles").map(qualifiedNames -> qualifiedNames != null ? (JsonArray)qualifiedNames : new JsonArray()).compose(qualifiedNames -> {
            List<Future<JsonArray>> asyncCheckResults = this.sendDataRequests((JsonArray)qualifiedNames, dataContext);
            return AsyncHelper.joinComposite(asyncCheckResults).transform(v -> {
                List allSucceeded = asyncCheckResults.stream().filter(Future::succeeded).map(Future::result).flatMap(JsonArray::stream).map(JsonObject.class::cast).collect(Collectors.toList());
                return Future.succeededFuture(allSucceeded);
            });
        });
    }

    private List<Future<JsonArray>> sendDataRequests(JsonArray qualifiedNames, DataContext dataContext) {
        return qualifiedNames.stream().map(Object::toString).map(DataRequest::new).map(dr -> DataVerticle.requestData(this.vertx, dr, dataContext).onSuccess(data -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.correlateWith(dataContext).debug("Retrieved health check of verticle {}", dr.getQualifiedName());
            }
        }).onFailure(t -> {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.correlateWith(dataContext).error("Could not retrieve health check data from verticle {}", dr.getQualifiedName(), t.getCause());
            }
        })).collect(Collectors.toList());
    }

    private JsonObject consolidateResults(List<JsonObject> healthCheckResults, DataContext dataContext) {
        AtomicReference<String> aggregatedStatus = new AtomicReference<String>(UP);
        HashMap consolidatedChecks = new HashMap();
        healthCheckResults.stream().forEach(checkResult -> {
            String checkId = checkResult.getString(ID_KEY);
            String status = checkResult.getString(STATUS_KEY);
            if (checkId == null || status == null) {
                LOGGER.correlateWith(dataContext).warn("Detected inconsistent health check");
                return;
            }
            if (consolidatedChecks.containsKey(checkId)) {
                if (!status.equals(((JsonObject)consolidatedChecks.get(checkId)).getString(STATUS_KEY))) {
                    LOGGER.correlateWith(dataContext).warn("Detected inconsistent status of health check {}", checkId);
                }
            } else {
                consolidatedChecks.put(checkId, checkResult);
                if (DOWN.equals(status)) {
                    aggregatedStatus.set(DOWN);
                }
            }
        });
        return new JsonObject().put(CHECKS_KEY, (Object)new JsonArray(new ArrayList(consolidatedChecks.values()))).put(STATUS_KEY, (Object)aggregatedStatus.get()).put(OUTCOME_KEY, (Object)aggregatedStatus.get());
    }

    private synchronized HealthCheck register(final String id, final long retentionTime, final boolean global, Function<NeonBee, Handler<Promise<Status>>> procedure, JsonObject healthCheckConfig) throws HealthCheckException {
        if (healthCheckConfig != null && !healthCheckConfig.getBoolean("enabled", Boolean.valueOf(true)).booleanValue()) {
            LOGGER.warn("HealthCheck '{}' is inactive.", id);
            return null;
        }
        if (this.checks.containsKey(id)) {
            throw new HealthCheckException("HealthCheck '" + id + "' already registered.");
        }
        this.healthChecks.register(id, this.getTimeout(healthCheckConfig).toMillis(), procedure.apply(NeonBee.get(this.vertx)));
        HealthCheck healthCheck = new HealthCheck(){
            private Future<CheckResult> lastCheckResult;
            private Instant lastCheck;

            @Override
            public synchronized Future<CheckResult> result() {
                Instant now = Instant.now();
                if (this.lastCheckResult == null || now.isAfter(this.lastCheck.plusSeconds(this.getRetentionTime()))) {
                    this.lastCheck = now;
                    this.lastCheckResult = HealthCheckRegistry.this.healthChecks.checkStatus(id);
                    return this.lastCheckResult;
                }
                return this.lastCheckResult;
            }

            @Override
            public String getId() {
                return id;
            }

            @Override
            public long getRetentionTime() {
                return retentionTime;
            }

            @Override
            public boolean isGlobal() {
                return global;
            }
        };
        this.checks.put(id, healthCheck);
        return healthCheck;
    }

    private Duration getTimeout(JsonObject healthCheckConfig) {
        long globalTimeout = NeonBee.get(this.vertx).getConfig().getHealthConfig().getTimeout();
        return Duration.ofSeconds(Optional.ofNullable(healthCheckConfig).map(c -> c.getLong("timeout", Long.valueOf(globalTimeout))).orElse(globalTimeout));
    }
}

