/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.hook.internal;

import io.neonbee.NeonBee;
import io.neonbee.hook.Hook;
import io.neonbee.hook.HookContext;
import io.neonbee.hook.HookRegistration;
import io.neonbee.hook.HookRegistry;
import io.neonbee.hook.HookType;
import io.neonbee.hook.Hooks;
import io.neonbee.hook.internal.DefaultHookContext;
import io.neonbee.hook.internal.DefaultHookRegistration;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultHookRegistry
implements HookRegistry {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private static final int NUMBER_HOOK_PARAMETERS = 3;
    final Map<HookType, List<HookRegistration>> hookRegistry;
    private final Vertx vertx;

    public DefaultHookRegistry(Vertx vertx) {
        this.vertx = vertx;
        this.hookRegistry = new ConcurrentHashMap<HookType, List<HookRegistration>>();
    }

    @Override
    public Future<Collection<HookRegistration>> registerInstanceHooks(Object instance, String correlationId) {
        return AsyncHelper.executeBlocking(this.vertx, () -> this.findHooks(instance, correlationId)).map(hookRegistrations -> {
            hookRegistrations.forEach(registration -> {
                LOGGER.correlateWith(correlationId).info("Registering hook {}", registration.getName());
                this.hookRegistry.computeIfAbsent(registration.getType(), type -> Collections.synchronizedList(new ArrayList())).add(registration);
            });
            return hookRegistrations;
        });
    }

    @Override
    public CompositeFuture executeHooks(HookType type, Map<String, Object> parameters) {
        List hookExecutions = this.hookRegistry.getOrDefault((Object)type, List.of()).stream().map(DefaultHookRegistration.class::cast).map(registration -> this.executeHook(NeonBee.get(this.vertx), (DefaultHookRegistration)registration, DefaultHookContext.of(type, parameters))).collect(Collectors.toList());
        return AsyncHelper.allComposite(hookExecutions);
    }

    @Override
    public Future<Collection<HookRegistration>> getHookRegistrations() {
        Collection registrations = this.hookRegistry.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return Future.succeededFuture((Object)registrations);
    }

    private Future<Void> executeHook(NeonBee neonBee, DefaultHookRegistration hookRegistration, HookContext context) {
        return Future.future(promise -> {
            try {
                hookRegistration.getHookMethod().invoke(hookRegistration.getRelatedObject(), neonBee, context, promise);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                promise.fail((Throwable)e);
            }
        });
    }

    private List<HookRegistration> findHooks(Object hookObject, String correlationId) {
        return Arrays.stream(hookObject.getClass().getMethods()).filter(method -> Modifier.isPublic(method.getModifiers()) && DefaultHookRegistry.isHook(method)).filter(method -> {
            if (DefaultHookRegistry.matchesHookSignature(method)) {
                return true;
            }
            LOGGER.correlateWith(correlationId).error("The hook method {} of class {} does not comply to the required method signature ([{}, {}, {}])", new Object[]{method.getName(), hookObject.getClass().getName(), NeonBee.class.getName(), HookContext.class.getName(), Promise.class.getName()});
            return false;
        }).map(method -> this.buildHookRegistrations((Method)method, hookObject)).flatMap(s -> s).collect(Collectors.toUnmodifiableList());
    }

    private Stream<HookRegistration> buildHookRegistrations(Method method, Object hookObject) {
        return Arrays.stream((Hook[])method.getAnnotationsByType(Hook.class)).map(annotation -> new DefaultHookRegistration(this, hookObject, method, annotation.value()));
    }

    private static boolean matchesHookSignature(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 3 && NeonBee.class.isAssignableFrom(parameterTypes[0]) && HookContext.class.isAssignableFrom(parameterTypes[1]) && Promise.class.isAssignableFrom(parameterTypes[2]);
    }

    private static boolean isHook(Method method) {
        return method.isAnnotationPresent(Hook.class) || method.isAnnotationPresent(Hooks.class);
    }
}

