/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexBlockList {
    private final List<Pattern> blockList = new ArrayList<Pattern>();
    private final List<Pattern> allowList = new ArrayList<Pattern>();

    public static RegexBlockList fromJson(Object json) {
        RegexBlockList blockList = new RegexBlockList();
        if (json instanceof String) {
            blockList.allow((String)json);
        } else if (json instanceof JsonArray) {
            ((JsonArray)json).stream().map(String.class::cast).forEach(blockList::allow);
        } else if (json instanceof JsonObject) {
            Object jsonBlock = ((JsonObject)json).getValue("block");
            if (jsonBlock instanceof String) {
                blockList.block((String)jsonBlock);
            } else if (jsonBlock instanceof JsonArray) {
                ((JsonArray)jsonBlock).stream().map(String.class::cast).forEach(blockList::block);
            } else if (jsonBlock != null) {
                throw new IllegalArgumentException("Cannot parse blocked type of JSON to initialize RegexBlockList");
            }
            Object jsonAllow = ((JsonObject)json).getValue("allow");
            if (jsonAllow instanceof String) {
                blockList.allow((String)jsonAllow);
            } else if (jsonAllow instanceof JsonArray) {
                ((JsonArray)jsonAllow).stream().map(String.class::cast).forEach(blockList::allow);
            } else if (jsonAllow != null) {
                throw new IllegalArgumentException("Cannot parse allowed type of JSON to initialize RegexBlockList");
            }
        } else if (json != null) {
            throw new IllegalArgumentException("Cannot parse type of JSON to initialize RegexBlockList");
        }
        return blockList;
    }

    public void block(String regex) {
        this.block(Pattern.compile(regex));
    }

    public void block(Pattern pattern) {
        this.blockList.add(pattern);
    }

    public void allow(String regex) {
        this.allow(Pattern.compile(regex));
    }

    public void allow(Pattern pattern) {
        this.allowList.add(pattern);
    }

    public void clear() {
        this.blockList.clear();
        this.allowList.clear();
    }

    public boolean isAllowed(String input) {
        boolean allowed = true;
        if (this.blockList.isEmpty() && !this.allowList.isEmpty() || RegexBlockList.isOnList(this.blockList, input)) {
            allowed = false;
        }
        if (!allowed && RegexBlockList.isOnList(this.allowList, input)) {
            allowed = true;
        }
        return allowed;
    }

    private static boolean isOnList(List<Pattern> list, String input) {
        return list.stream().map(pattern -> pattern.matcher(input)).anyMatch(Matcher::matches);
    }
}

