/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SelfFirstClassLoader
extends URLClassLoader {
    @VisibleForTesting
    final Predicate<String> parentPreferredPredicate;
    private final Map<String, Class<?>> loadedClasses = new ConcurrentHashMap();

    public SelfFirstClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, Collections.emptyList());
    }

    public SelfFirstClassLoader(URL[] urls, ClassLoader parent, List<String> parentPreferred) {
        super(urls, parent);
        this.parentPreferredPredicate = SelfFirstClassLoader.getClassNamePredicate(parentPreferred);
    }

    @VisibleForTesting
    static Predicate<String> getClassNamePredicate(List<String> classNames) {
        String pattern = classNames.stream().filter(Predicate.not(Strings::isNullOrEmpty)).map(className -> Arrays.stream(className.split("\\*", -1)).map(Pattern::quote).collect(Collectors.joining(".*"))).collect(Collectors.joining("|"));
        return !pattern.isEmpty() ? Pattern.compile(pattern).asMatchPredicate() : Predicates.alwaysFalse();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> classToReturn = this.loadedClasses.get(name);
        if (classToReturn != null) {
            return classToReturn;
        }
        if (this.loadFromParent(name)) {
            try {
                classToReturn = this.getParent().loadClass(name);
                this.loadedClasses.put(name, classToReturn);
                return classToReturn;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            classToReturn = this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            classToReturn = this.getParent().loadClass(name);
        }
        if (resolve) {
            this.resolveClass(classToReturn);
        }
        this.loadedClasses.put(name, classToReturn);
        return classToReturn;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> parentResources;
        ArrayList<URL> resources = Collections.list(this.findResources(name));
        if (this.getParent() != null && (parentResources = this.getParent().getResources(name)).hasMoreElements()) {
            resources.addAll(Collections.list(parentResources));
        }
        return Collections.enumeration(resources);
    }

    @VisibleForTesting
    boolean loadFromParent(String className) {
        return this.parentPreferredPredicate.test(className);
    }
}

