/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.cluster.discovery;

import com.hazelcast.cluster.Address;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainNameServiceDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainNameServiceDiscoveryStrategy.class);
    private final DiscoveryNode discoveryNode;
    private final String dnsName;
    private int port;

    DomainNameServiceDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        this.discoveryNode = discoveryNode;
        this.dnsName = (String)((Object)properties.get("DNS_NAME"));
    }

    public void start() {
        this.port = this.discoveryNode.getPrivateAddress().getPort();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start at " + this.discoveryNode.getPrivateAddress());
        }
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Discover Nodes at {}.", (Object)this.discoveryNode.getPrivateAddress());
        }
        try {
            Set ips = Arrays.stream(InetAddress.getAllByName(this.dnsName)).map(adr -> adr.getHostAddress()).collect(Collectors.toSet());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Resolved IPs: " + String.join((CharSequence)";", ips));
            }
            return ips.stream().map(ip -> {
                try {
                    return new SimpleDiscoveryNode(new Address(ip, this.port));
                }
                catch (UnknownHostException e) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Error while building address with IP " + ip);
                    }
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        catch (UnknownHostException e) {
            LOGGER.error("Error while resolving DNS name {}.", (Object)this.dnsName, (Object)e);
            return Collections.emptyList();
        }
    }

    public void destroy() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Destroy at " + this.discoveryNode.getPrivateAddress());
        }
    }
}

