/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.codec;

import io.neonbee.NeonBee;
import io.neonbee.entity.EntityModelDefinition;
import io.neonbee.entity.EntityModelManager;
import io.neonbee.entity.EntityWrapper;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.DeserializerResult;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityWrapperMessageCodec
implements MessageCodec<EntityWrapper, EntityWrapper> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ENTITY = "entity";
    private static final String NAME = "name";
    private static final String NAMESPACE = "namespace";
    private static final String ENTITY_TYPE = "entityType";
    private final Vertx vertx;

    public EntityWrapperMessageCodec(Vertx vertx) {
        this.vertx = vertx;
    }

    public void encodeToWire(Buffer buffer, EntityWrapper entityWrapper) {
        FullQualifiedName entityTypeName = entityWrapper.getTypeName();
        ServiceMetadata serviceMetadata = this.getServiceMetadata(entityTypeName);
        if (serviceMetadata == null) {
            throw new IllegalStateException("Service metadata was not loaded yet for " + entityWrapper.getTypeName());
        }
        EdmEntityType entityType = serviceMetadata.getEdm().getEntityType(entityTypeName);
        EdmEntitySet entitySet = serviceMetadata.getEdm().getEntityContainer().getEntitySet(entityTypeName.getName());
        ContextURL contextUrl = ContextURL.with().entitySet(entitySet).build();
        EntityCollectionSerializerOptions.Builder optionsBuilder = EntityCollectionSerializerOptions.with().contextURL(contextUrl);
        EntityCollectionSerializerOptions options = optionsBuilder.build();
        try {
            EntityCollection entityCollection = new EntityCollection();
            entityCollection.getEntities().addAll(entityWrapper.getEntities());
            JsonObject json = new JsonObject().put(ENTITY_TYPE, (Object)new JsonObject().put(NAMESPACE, (Object)entityTypeName.getNamespace()).put(NAME, (Object)entityTypeName.getName()));
            ODataSerializer odataSerializer = EntityModelManager.getBufferedOData().createSerializer(ContentType.APPLICATION_JSON);
            SerializerResult odataSerializerResult = odataSerializer.entityCollection(serviceMetadata, entityType, (AbstractEntityCollection)entityCollection, options);
            json.put(ENTITY, (Object)Buffer.buffer((byte[])odataSerializerResult.getContent().readAllBytes()).toString());
            buffer.appendString(json.toString());
        }
        catch (IOException | SerializerException e) {
            LOGGER.warn("Error while serializing entity wrapper.", e);
            throw new RuntimeException(e);
        }
    }

    private ServiceMetadata getServiceMetadata(FullQualifiedName entityTypeName) {
        return NeonBee.get(this.vertx).getModelManager().getBufferedModel(EntityModelDefinition.retrieveNamespace(entityTypeName.getNamespace())).getEdmxMetadata(entityTypeName.getNamespace());
    }

    public EntityWrapper decodeFromWire(int position, Buffer buffer) {
        JsonObject jsonObject = buffer.getBuffer(position, buffer.length()).toJsonObject();
        JsonObject entityTypeJsonObject = jsonObject.getJsonObject(ENTITY_TYPE);
        FullQualifiedName entityTypeName = new FullQualifiedName(entityTypeJsonObject.getString(NAMESPACE), entityTypeJsonObject.getString(NAME));
        ServiceMetadata serviceMetadata = this.getServiceMetadata(entityTypeName);
        EdmEntityType entityType = serviceMetadata.getEdm().getEntityType(entityTypeName);
        try {
            String payload = jsonObject.getString(ENTITY);
            ODataDeserializer odataDeserializer = EntityModelManager.getBufferedOData().createDeserializer(ContentType.APPLICATION_JSON, serviceMetadata);
            DeserializerResult odataDeserializerResult = odataDeserializer.entityCollection((InputStream)new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8)), entityType);
            return new EntityWrapper(entityTypeName, (List<Entity>)odataDeserializerResult.getEntityCollection().getEntities());
        }
        catch (DeserializerException e) {
            LOGGER.warn("Error while deserializing entity wrapper.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public EntityWrapper transform(EntityWrapper entity) {
        return entity;
    }

    public String name() {
        return "entitywrapper";
    }

    public byte systemCodecID() {
        return -1;
    }
}

