/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.codec;

import io.neonbee.internal.json.ImmutableJsonObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;

public class ImmutableJsonObjectMessageCodec
implements MessageCodec<ImmutableJsonObject, ImmutableJsonObject> {
    public void encodeToWire(Buffer buffer, ImmutableJsonObject jsonObject) {
        Buffer encoded = jsonObject.toBuffer();
        buffer.appendInt(encoded.length());
        buffer.appendBuffer(encoded);
    }

    public ImmutableJsonObject decodeFromWire(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        int nextPos = pos + 4;
        return new ImmutableJsonObject(buffer.slice(nextPos, nextPos + length));
    }

    public ImmutableJsonObject transform(ImmutableJsonObject jsonObject) {
        return jsonObject;
    }

    public String name() {
        return "immutablejsonobject";
    }

    public byte systemCodecID() {
        return -1;
    }
}

