/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.deploy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import io.neonbee.NeonBee;
import io.neonbee.entity.EntityModelDefinition;
import io.neonbee.internal.deploy.Deployable;
import io.neonbee.internal.deploy.PendingDeployment;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.internal.scanner.ClassPathScanner;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DeployableModels
extends Deployable {
    public static final String NEONBEE_MODELS = "NeonBee-Models";
    public static final String NEONBEE_MODEL_EXTENSIONS = "NeonBee-Model-Extensions";
    @VisibleForTesting
    final EntityModelDefinition modelDefinition;

    public static Future<DeployableModels> fromJar(Vertx vertx, Path jarPath) {
        return ClassPathScanner.forJarFile(vertx, jarPath).compose(classPathScanner -> DeployableModels.scanClassPath(vertx, classPathScanner).eventually(classPathScanner.close(vertx)));
    }

    @VisibleForTesting
    static Future<DeployableModels> scanClassPath(Vertx vertx, ClassPathScanner classPathScanner) {
        ClassLoader classLoader = classPathScanner.getClassLoader();
        Future csnModelDefinitions = classPathScanner.scanManifestFiles(vertx, NEONBEE_MODELS).compose(csnModelNames -> DeployableModels.readModelPayloads(vertx, classLoader, csnModelNames));
        Future associatedModelDefinitions = classPathScanner.scanManifestFiles(vertx, NEONBEE_MODEL_EXTENSIONS).compose(associatedModelNames -> DeployableModels.readModelPayloads(vertx, classLoader, associatedModelNames));
        return CompositeFuture.all((Future)csnModelDefinitions, (Future)associatedModelDefinitions).map(compositeResult -> new EntityModelDefinition((Map)csnModelDefinitions.result(), (Map)associatedModelDefinitions.result())).map(DeployableModels::new);
    }

    public DeployableModels(EntityModelDefinition modelDefinition) {
        this.modelDefinition = modelDefinition;
    }

    @Override
    public String getIdentifier() {
        return this.modelDefinition.toString();
    }

    @Override
    public PendingDeployment deploy(NeonBee neonBee) {
        return new PendingDeployment(neonBee, this, neonBee.getModelManager().registerModels(this.modelDefinition).mapEmpty()){

            @Override
            protected Future<Void> undeploy(String deploymentId) {
                return this.neonBee.getModelManager().unregisterModels(DeployableModels.this.modelDefinition).mapEmpty();
            }
        };
    }

    @VisibleForTesting
    static Future<Map<String, byte[]>> readModelPayloads(Vertx vertx, ClassLoader classLoader, List<String> modelPaths) {
        return AsyncHelper.executeBlocking(vertx, () -> {
            HashMap<String, byte[]> modelDefinitions = new HashMap<String, byte[]>(modelPaths.size());
            for (String modelPath : modelPaths) {
                InputStream input = Objects.requireNonNull(classLoader.getResourceAsStream(modelPath), "Specified model path wasn't found in NeonBee module");
                try {
                    modelDefinitions.put(modelPath, ByteStreams.toByteArray((InputStream)input));
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            return modelDefinitions;
        });
    }
}

