/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.deploy;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.NeonBee;
import io.neonbee.internal.deploy.Deployable;
import io.neonbee.internal.deploy.PendingDeployment;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.internal.helper.ConfigHelper;
import io.neonbee.internal.helper.ThreadHelper;
import io.neonbee.internal.json.ImmutableJsonObject;
import io.neonbee.internal.scanner.ClassPathScanner;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.CompositeFuture;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class DeployableVerticle
extends Deployable {
    public static final String NEONBEE_DEPLOYABLES = "NeonBee-Deployables";
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    @VisibleForTesting
    final Verticle verticleInstance;
    @VisibleForTesting
    final Class<? extends Verticle> verticleClass;
    @VisibleForTesting
    final DeploymentOptions options;

    public static Future<Collection<DeployableVerticle>> fromJar(Vertx vertx, Path jarPath, ClassLoader verticleClassLoader) {
        return ClassPathScanner.forJarFile(vertx, jarPath).compose(classPathScanner -> DeployableVerticle.scanClassPath(vertx, classPathScanner, verticleClassLoader).eventually(classPathScanner.close(vertx)));
    }

    static Future<Collection<DeployableVerticle>> scanClassPath(Vertx vertx, ClassPathScanner classPathScanner, ClassLoader verticleClassLoader) {
        return classPathScanner.scanManifestFiles(vertx, NEONBEE_DEPLOYABLES).compose(classNames -> {
            List deployables = classNames.stream().map(className -> DeployableVerticle.fromClassName(vertx, className, verticleClassLoader)).collect(Collectors.toList());
            return AsyncHelper.allComposite(deployables).map(CompositeFuture::list);
        });
    }

    public static Future<DeployableVerticle> fromClassName(Vertx vertx, String className) {
        return DeployableVerticle.fromClassName(vertx, className, (JsonObject)null);
    }

    public static Future<DeployableVerticle> fromClassName(Vertx vertx, String className, JsonObject defaultConfig) {
        return DeployableVerticle.fromClassName(vertx, className, ThreadHelper.getClassLoader(), defaultConfig);
    }

    public static Future<DeployableVerticle> fromClassName(Vertx vertx, String className, ClassLoader classLoader) {
        return DeployableVerticle.fromClassName(vertx, className, classLoader, null);
    }

    public static Future<DeployableVerticle> fromClassName(Vertx vertx, String className, ClassLoader classLoader, JsonObject defaultConfig) {
        return AsyncHelper.executeBlocking(vertx, () -> classLoader.loadClass(className)).compose(verticleClass -> DeployableVerticle.fromClass(vertx, verticleClass, defaultConfig));
    }

    public static Future<DeployableVerticle> fromClass(Vertx vertx, Class<? extends Verticle> verticleClass) {
        return DeployableVerticle.fromClass(vertx, verticleClass, null);
    }

    public static Future<DeployableVerticle> fromClass(Vertx vertx, Class<? extends Verticle> verticleClass, JsonObject defaultConfig) {
        return DeployableVerticle.readVerticleConfig(vertx, verticleClass.getName(), defaultConfig).compose(deploymentOptions -> Future.succeededFuture((Object)new DeployableVerticle(verticleClass, (DeploymentOptions)deploymentOptions)));
    }

    public static Future<DeployableVerticle> fromVerticle(Vertx vertx, Verticle verticleInstance) {
        return DeployableVerticle.fromVerticle(vertx, verticleInstance, null);
    }

    public static Future<DeployableVerticle> fromVerticle(Vertx vertx, Verticle verticleInstance, JsonObject defaultConfig) {
        return DeployableVerticle.readVerticleConfig(vertx, verticleInstance.getClass().getName(), defaultConfig).compose(options -> Future.succeededFuture((Object)new DeployableVerticle(verticleInstance, (DeploymentOptions)options)));
    }

    public DeployableVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options) {
        this.verticleInstance = null;
        this.verticleClass = verticleClass;
        this.options = options;
    }

    public DeployableVerticle(Verticle verticleInstance, DeploymentOptions options) {
        this.verticleInstance = verticleInstance;
        this.verticleClass = null;
        this.options = options;
    }

    @Override
    public String getIdentifier() {
        if (this.verticleClass != null) {
            return this.verticleClass.getName();
        }
        return this.verticleInstance.getClass().getName();
    }

    @Override
    public PendingDeployment deploy(NeonBee neonBee) {
        final Vertx vertx = neonBee.getVertx();
        return new PendingDeployment(neonBee, this, this.verticleInstance != null ? vertx.deployVerticle(this.verticleInstance, this.options) : vertx.deployVerticle(this.verticleClass, this.options)){

            @Override
            protected Future<Void> undeploy(String deploymentId) {
                return vertx.undeploy(deploymentId);
            }
        };
    }

    @VisibleForTesting
    static Future<DeploymentOptions> readVerticleConfig(Vertx vertx, String className, JsonObject defaultConfig) {
        return ConfigHelper.readConfig(vertx, className, (JsonObject)(defaultConfig != null ? defaultConfig : ImmutableJsonObject.EMPTY)).map(config -> defaultConfig != null && config != defaultConfig ? defaultConfig.copy().mergeIn(config, 2) : config).onFailure(throwable -> LOGGER.warn("Could not read deployment options for deployable {}", className, throwable)).map(DeploymentOptions::new);
    }
}

