/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.handler;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.config.AuthHandlerConfig;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import java.util.List;
import java.util.stream.Collectors;

public interface ChainAuthHandler
extends AuthenticationHandler {
    @VisibleForTesting
    public static final ChainAuthHandler NOOP_AUTHENTICATION_HANDLER = RoutingContext::next;

    public static ChainAuthHandler create(Vertx vertx, List<AuthHandlerConfig> authChainConfig) {
        if (authChainConfig == null || authChainConfig.isEmpty()) {
            return NOOP_AUTHENTICATION_HANDLER;
        }
        final io.vertx.ext.web.handler.ChainAuthHandler chainAuthHandler = io.vertx.ext.web.handler.ChainAuthHandler.any();
        List<AuthenticationHandler> authHandlers = authChainConfig.stream().map(config -> config.createAuthHandler(vertx)).collect(Collectors.toList());
        authHandlers.forEach(arg_0 -> ((io.vertx.ext.web.handler.ChainAuthHandler)chainAuthHandler).add(arg_0));
        return new ChainAuthHandler(){

            public void handle(RoutingContext event) {
                chainAuthHandler.handle((Object)event);
            }
        };
    }
}

