/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.handler;

import io.neonbee.NeonBee;
import io.neonbee.data.DataException;
import io.neonbee.handler.ErrorHandler;
import io.neonbee.internal.handler.CorrelationIdHandler;
import io.neonbee.internal.helper.FileSystemHelper;
import io.neonbee.logging.LoggingFacade;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.validation.BadRequestException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public class DefaultErrorHandler
implements ErrorHandler {
    public static final Path DEFAULT_ERROR_HANDLER_TEMPLATE = Path.of("META-INF/neonbee/error-template.html", new String[0]);
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private static final int HTTP_ERROR_CODE_LOWER_LIMIT = 100;
    private static final int HTTP_ERROR_CODE_UPPER_LIMIT = 1000;
    private String errorTemplate;

    @Override
    public Future<ErrorHandler> initialize(NeonBee neonBee) {
        return this.readErrorTemplate(neonBee).map(errorTemplate -> {
            this.errorTemplate = errorTemplate;
            return this;
        });
    }

    private Future<String> readErrorTemplate(NeonBee neonBee) {
        String errorTemplatePath = neonBee.getServerConfig().getErrorHandlerTemplate();
        Path p = errorTemplatePath == null ? DEFAULT_ERROR_HANDLER_TEMPLATE : Path.of(errorTemplatePath, new String[0]);
        return FileSystemHelper.readFile(neonBee.getVertx(), p).map(Buffer::toString);
    }

    public void handle(RoutingContext routingContext) {
        Throwable failure = routingContext.failure();
        if (failure != null) {
            LOGGER.correlateWith(routingContext).error(failure.getMessage(), failure);
        }
        String errorMessage = null;
        int errorCode = routingContext.statusCode();
        if (errorCode == -1 && failure instanceof DataException) {
            errorCode = ((DataException)failure).failureCode();
        }
        if (errorCode < 100 || errorCode >= 1000) {
            errorCode = HttpResponseStatus.INTERNAL_SERVER_ERROR.code();
            errorMessage = HttpResponseStatus.INTERNAL_SERVER_ERROR.reasonPhrase();
        }
        if (errorCode != -1 && errorMessage == null) {
            routingContext.response().setStatusCode(errorCode);
            errorMessage = routingContext.response().getStatusMessage();
        }
        if (failure instanceof BadRequestException) {
            errorMessage = failure.getMessage();
        }
        this.answerWithError(routingContext, errorCode, errorMessage);
    }

    protected String createPlainResponse(RoutingContext routingContext, int errorCode, String errorMessage) {
        StringBuilder builder = new StringBuilder().append("Error ").append(errorCode).append(": ").append(errorMessage);
        String correlationId = CorrelationIdHandler.getCorrelationId(routingContext);
        if (correlationId != null) {
            builder.append(" (Correlation ID: ").append(correlationId).append(')');
        }
        return builder.toString();
    }

    protected JsonObject createJsonResponse(RoutingContext routingContext, int errorCode, String errorMessage) {
        JsonObject error = new JsonObject().put("code", (Object)errorCode).put("message", (Object)errorMessage);
        Optional.ofNullable(CorrelationIdHandler.getCorrelationId(routingContext)).ifPresent(id -> error.put("correlationId", id));
        return new JsonObject().put("error", (Object)error);
    }

    protected String createHtmlResponse(RoutingContext routingContext, int errorCode, String errorMessage) {
        return this.errorTemplate.replace("{errorCode}", Integer.toString(errorCode)).replace("{errorMessage}", errorMessage).replace("{correlationId}", CorrelationIdHandler.getCorrelationId(routingContext));
    }

    private boolean sendError(RoutingContext routingContext, String mime, int errorCode, String errorMessage) {
        HttpServerResponse response = routingContext.response();
        if (mime.startsWith("text/html")) {
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
            response.end(this.createHtmlResponse(routingContext, errorCode, errorMessage));
        } else if (mime.startsWith("application/json")) {
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            response.end(this.createJsonResponse(routingContext, errorCode, errorMessage).toBuffer());
        } else if (mime.startsWith("text/plain")) {
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain");
            response.end(this.createPlainResponse(routingContext, errorCode, errorMessage));
        } else {
            return false;
        }
        return true;
    }

    private void answerWithError(RoutingContext routingContext, int errorCode, String errorMessage) {
        routingContext.response().setStatusCode(errorCode);
        if (!this.sendErrorResponseMIME(routingContext, errorCode, errorMessage) && !this.sendErrorAcceptMIME(routingContext, errorCode, errorMessage)) {
            this.sendError(routingContext, "text/plain", errorCode, errorMessage);
        }
    }

    private boolean sendErrorResponseMIME(RoutingContext routingContext, int errorCode, String errorMessage) {
        String mime = routingContext.response().headers().get(HttpHeaders.CONTENT_TYPE);
        return mime != null && this.sendError(routingContext, mime, errorCode, errorMessage);
    }

    private boolean sendErrorAcceptMIME(RoutingContext routingContext, int errorCode, String errorMessage) {
        List acceptableMimes = routingContext.parsedHeaders().accept();
        for (MIMEHeader accept : acceptableMimes) {
            if (!this.sendError(routingContext, accept.value(), errorCode, errorMessage)) continue;
            return true;
        }
        return false;
    }
}

