/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.handler;

import io.neonbee.logging.LoggingFacade;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.PlatformHandler;
import java.util.Optional;

public class LoggerHandler
implements PlatformHandler {
    private static final LoggingFacade LOGGER = LoggingFacade.create();

    public void handle(RoutingContext routingContext) {
        routingContext.addBodyEndHandler(nothing -> this.log(routingContext, System.currentTimeMillis()));
        routingContext.next();
    }

    private void log(RoutingContext routingContext, long timestamp) {
        String version;
        HttpServerRequest request = routingContext.request();
        switch (request.version()) {
            case HTTP_1_0: {
                version = "HTTP/1.0";
                break;
            }
            case HTTP_1_1: {
                version = "HTTP/1.1";
                break;
            }
            case HTTP_2: {
                version = "HTTP/2.0";
                break;
            }
            default: {
                version = "-";
            }
        }
        int statusCode = request.response().getStatusCode();
        String message = String.format("%s - %s %s %s %d %d - %d ms", Optional.ofNullable(request.remoteAddress()).map(SocketAddress::host).orElse(null), request.method(), request.uri(), version, statusCode, request.response().bytesWritten(), System.currentTimeMillis() - timestamp);
        LOGGER.correlateWith(routingContext);
        if (statusCode >= HttpResponseStatus.INTERNAL_SERVER_ERROR.code()) {
            LOGGER.error(message);
        } else if (statusCode >= HttpResponseStatus.BAD_REQUEST.code()) {
            LOGGER.warn(message);
        } else {
            LOGGER.info(message);
        }
    }
}

