/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.helper;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.Shareable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CollectionHelper {
    private CollectionHelper() {
    }

    public static <T> List<T> mutableCopyOf(List<T> list) {
        return Optional.ofNullable(list).map(Collection::stream).orElseGet(Stream::empty).map(CollectionHelper::copyOf).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> Set<T> mutableCopyOf(Set<T> set) {
        return Optional.ofNullable(set).map(Collection::stream).orElseGet(Stream::empty).map(CollectionHelper::copyOf).collect(Collectors.toCollection(HashSet::new));
    }

    public static <T, C extends Collection<T>> C mutableCopyOf(C collection, Supplier<C> collectionFactory) {
        return (C)((Collection)Optional.ofNullable(collection).map(Collection::stream).orElseGet(Stream::empty).map(CollectionHelper::copyOf).collect(Collectors.toCollection(collectionFactory)));
    }

    public static <K, V> Map<K, V> mutableCopyOf(Map<K, V> map) {
        return Optional.ofNullable(map).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).collect(Collectors.toMap(entry -> CollectionHelper.copyOf(entry.getKey()), entry -> CollectionHelper.copyOf(entry.getValue()), (valueA, valueB) -> valueB, NullLiberalMergingHashMap::new));
    }

    public static <T> T copyOf(T object) {
        if (Objects.isNull(object)) {
            return null;
        }
        if (object instanceof Buffer) {
            return (T)((Buffer)object).copy();
        }
        if (object instanceof List) {
            return (T)CollectionHelper.mutableCopyOf((List)object);
        }
        if (object instanceof Set) {
            return (T)CollectionHelper.mutableCopyOf((Set)object);
        }
        if (object instanceof Map) {
            return (T)CollectionHelper.mutableCopyOf((Map)object);
        }
        if (object.getClass().isArray()) {
            if (object instanceof byte[]) {
                return (T)Arrays.copyOf((byte[])object, ((byte[])object).length);
            }
            if (object instanceof short[]) {
                return (T)Arrays.copyOf((short[])object, ((short[])object).length);
            }
            if (object instanceof int[]) {
                return (T)Arrays.copyOf((int[])object, ((int[])object).length);
            }
            if (object instanceof char[]) {
                return (T)Arrays.copyOf((char[])object, ((char[])object).length);
            }
            if (object instanceof float[]) {
                return (T)Arrays.copyOf((float[])object, ((float[])object).length);
            }
            if (object instanceof double[]) {
                return (T)Arrays.copyOf((double[])object, ((double[])object).length);
            }
            if (object instanceof boolean[]) {
                return (T)Arrays.copyOf((boolean[])object, ((boolean[])object).length);
            }
            Class<?> componentType = object.getClass().getComponentType();
            Object[] array = (Object[])Array.newInstance(componentType, ((Object[])object).length);
            Arrays.setAll(array, index -> CollectionHelper.copyOf(((Object[])object)[index]));
            return (T)array;
        }
        if (object instanceof Shareable) {
            return (T)((Shareable)object).copy();
        }
        return object;
    }

    public static Map<String, List<String>> multiMapToMap(MultiMap multiMap) {
        return multiMap.entries().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList((String)entry.getValue()), (listA, listB) -> Stream.concat(listA.stream(), listB.stream()).collect(Collectors.toList())));
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> identityMapCollector() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <K, V> boolean isNullOrEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static class NullLiberalMergingHashMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1L;

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            if (value != null) {
                return super.merge(key, value, remappingFunction);
            }
            this.put(key, this.containsKey(key) ? (Object)remappingFunction.apply((V)this.get(key), (V)null) : null);
            return null;
        }
    }
}

