/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.helper;

import java.util.concurrent.atomic.AtomicReference;

public final class ThreadHelper {
    private ThreadHelper() {
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        classLoader = ThreadHelper.getOwnClass().getClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        return ThreadHelper.class.getClassLoader();
    }

    public static Class<?> getOwnClass() {
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        return walker.walk(stackStream -> stackStream.map(StackWalker.StackFrame::getDeclaringClass).filter(declaringClass -> !ThreadHelper.class.equals(declaringClass)).findFirst().get());
    }

    public static Class<?> getCallingClass() {
        AtomicReference callingClass = new AtomicReference();
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        return walker.walk(stackStream -> stackStream.map(StackWalker.StackFrame::getDeclaringClass).filter(declaringClass -> !ThreadHelper.class.equals(declaringClass) && !callingClass.compareAndSet(null, declaringClass) && !declaringClass.equals(callingClass.get())).findFirst().orElse(null));
    }
}

