/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.json;

import io.neonbee.internal.json.ImmutableJsonObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;

public final class ImmutableJsonArray
extends JsonArray {
    public static final ImmutableJsonArray EMPTY = new ImmutableJsonArray();
    private final JsonArray array;

    public ImmutableJsonArray() {
        this(Collections.emptyList());
    }

    public ImmutableJsonArray(String json) {
        this(new JsonArray(json));
    }

    public ImmutableJsonArray(List list) {
        this(new JsonArray(list));
    }

    public ImmutableJsonArray(Buffer buf) {
        this(new JsonArray(buf));
    }

    public ImmutableJsonArray(JsonArray arr) {
        super(Collections.unmodifiableList(arr.getList()));
        this.array = arr instanceof ImmutableJsonArray ? ((ImmutableJsonArray)arr).array : arr;
    }

    public ImmutableJsonObject getJsonObject(int pos) {
        JsonObject object = super.getJsonObject(pos);
        return object != null ? new ImmutableJsonObject(object) : null;
    }

    public ImmutableJsonArray getJsonArray(int pos) {
        JsonArray array = super.getJsonArray(pos);
        return array != null ? new ImmutableJsonArray(array) : null;
    }

    public Object getValue(int pos) {
        Object val = super.getValue(pos);
        if (val instanceof JsonObject) {
            val = new ImmutableJsonObject((JsonObject)val);
        } else if (val instanceof JsonArray) {
            val = new ImmutableJsonArray((JsonArray)val);
        }
        return val;
    }

    public ImmutableJsonArray copy() {
        return this;
    }

    public boolean equals(Object other) {
        return this.array.equals(other instanceof ImmutableJsonArray ? ((ImmutableJsonArray)((Object)other)).array : other);
    }

    public int hashCode() {
        return this.array.hashCode();
    }

    public JsonArray mutableCopy() {
        return new JsonArray(this.getList()).copy();
    }
}

