/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.scanner;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.internal.helper.FileSystemHelper;
import io.neonbee.internal.helper.JarHelper;
import io.neonbee.internal.helper.ThreadHelper;
import io.neonbee.internal.scanner.AnnotationClassVisitor;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassPathScanner {
    public static final Pattern SEPARATOR_PATTERN = Pattern.compile(";");
    private final ClassLoader classLoader;

    public ClassPathScanner() {
        this(ThreadHelper.getClassLoader());
    }

    public ClassPathScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static Future<CloseableClassPathScanner> forJarFile(Vertx vertx, Path jarPath) {
        return FileSystemHelper.exists(vertx, jarPath).compose(jarExists -> {
            URL jarUrl;
            if (!jarExists.booleanValue()) {
                return Future.failedFuture((Throwable)new NoSuchFileException("JAR path does not exist: " + jarPath.toString()));
            }
            try {
                jarUrl = jarPath.toUri().toURL();
            }
            catch (MalformedURLException e) {
                return Future.failedFuture((Throwable)e);
            }
            return Future.succeededFuture((Object)new CloseableClassPathScanner(new URLClassLoader(new URL[]{jarUrl}, null)));
        });
    }

    public Future<List<String>> scanManifestFiles(Vertx vertx, String attributeName) {
        return AsyncHelper.executeBlocking(vertx, () -> {
            ArrayList resources = new ArrayList();
            for (URL manifestResources : this.getManifestResourceURLs()) {
                InputStream inputStream = manifestResources.openStream();
                try {
                    Manifest manifest = new Manifest(inputStream);
                    String attributeValue = manifest.getMainAttributes().getValue(attributeName);
                    if (Strings.isNullOrEmpty((String)attributeValue)) continue;
                    SEPARATOR_PATTERN.splitAsStream(attributeValue).map(String::trim).forEach(resources::add);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            return resources;
        });
    }

    public Future<List<String>> scanForAnnotation(Vertx vertx, Class<? extends Annotation> annotationClass) {
        return this.scanForAnnotation(vertx, annotationClass, ElementType.TYPE);
    }

    public Future<List<String>> scanForAnnotation(Vertx vertx, Class<? extends Annotation> annotationClass, ElementType ... elementTypes) {
        return this.scanForAnnotation(vertx, List.of(annotationClass), elementTypes);
    }

    public Future<List<String>> scanForAnnotation(Vertx vertx, List<Class<? extends Annotation>> annotationClasses, ElementType ... elementTypes) {
        Future<List<String>> classesFromDirectories = this.scanWithPredicate(vertx, ClassPathScanner::isClassFile);
        Future classesFromJars = this.scanJarFilesWithPredicate(vertx, ClassPathScanner::isClassFile).map(classes -> classes.stream().map(JarHelper::extractFilePath).collect(Collectors.toList()));
        return CompositeFuture.all(classesFromDirectories, (Future)classesFromJars).compose(compositeResult -> AsyncHelper.executeBlocking(vertx, () -> {
            List classVisitors = annotationClasses.stream().map(annotationClass -> new AnnotationClassVisitor((Class<? extends Annotation>)annotationClass, elementTypes)).collect(Collectors.toList());
            Streams.concat((Stream[])new Stream[]{((List)classesFromDirectories.result()).stream(), ((List)classesFromJars.result()).stream()}).forEach(name -> {
                try {
                    String resourceName = name.replace(".", "/").replaceFirst("/class$", ".class");
                    for (AnnotationClassVisitor acv : classVisitors) {
                        ClassReader classReader = new ClassReader(this.classLoader.getResourceAsStream(resourceName));
                        classReader.accept((ClassVisitor)acv, 0);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return classVisitors.stream().flatMap(acv -> acv.getClassNames().stream()).distinct().collect(Collectors.toList());
        }));
    }

    public Future<List<String>> scanWithPredicate(Vertx vertx, Predicate<String> predicate) {
        return AsyncHelper.executeBlocking(vertx, () -> {
            ArrayList resources = new ArrayList();
            Enumeration<URL> rootResources = this.classLoader.getResources("");
            while (rootResources.hasMoreElements()) {
                URL resource = rootResources.nextElement();
                if (!"file".equals(resource.getProtocol())) continue;
                try {
                    Path resourcePath = Paths.get(resource.toURI());
                    if (!Files.isDirectory(resourcePath, new LinkOption[0])) continue;
                    this.scanDirectoryWithPredicateRecursive(resourcePath, predicate).forEach(path -> resources.add(resourcePath.relativize((Path)path).toString()));
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            return resources;
        });
    }

    public Future<List<URI>> scanJarFilesWithPredicate(Vertx vertx, Predicate<String> predicate) {
        return AsyncHelper.executeBlocking(vertx, () -> {
            ArrayList resources = new ArrayList();
            for (URL manifestResource : this.getManifestResourceURLs()) {
                URI uri = manifestResource.toURI();
                if (!"jar".equals(uri.getScheme())) continue;
                FileSystem fileSystem = FileSystems.newFileSystem(uri, Map.of());
                try {
                    Path rootPath = fileSystem.getPath("/", new String[0]);
                    this.scanDirectoryWithPredicateRecursive(rootPath, predicate).forEach(path -> resources.add(path.toUri()));
                }
                finally {
                    if (fileSystem == null) continue;
                    fileSystem.close();
                }
            }
            return resources;
        });
    }

    private List<URL> getManifestResourceURLs() throws IOException {
        return ImmutableList.copyOf((Iterator)Iterators.forEnumeration(this.classLoader.getResources("META-INF/MANIFEST.MF")));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="Spotbugs isn't telling the truth there is no null check in here")
    private List<Path> scanDirectoryWithPredicateRecursive(Path basePath, Predicate<String> predicate) throws IOException {
        try (Stream<Path> walk = Files.walk(basePath, new FileVisitOption[0]);){
            List<Path> list = walk.filter(path -> predicate.test(basePath.relativize((Path)path).toString())).collect(Collectors.toList());
            return list;
        }
    }

    private static boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    public static class CloseableClassPathScanner
    extends ClassPathScanner
    implements Closeable {
        private static final LoggingFacade LOGGER = LoggingFacade.create();

        public CloseableClassPathScanner(URLClassLoader urlClassLoader) {
            super(urlClassLoader);
        }

        @Override
        public URLClassLoader getClassLoader() {
            return (URLClassLoader)super.getClassLoader();
        }

        @Override
        public void close() throws IOException {
            this.getClassLoader().close();
        }

        public <U> Function<Void, Future<U>> close(Vertx vertx) {
            return nothing -> AsyncHelper.executeBlocking(vertx, () -> {
                try {
                    this.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close {}", this, e);
                }
            }).mapEmpty();
        }
    }
}

