/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.tracking;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.data.DataContext;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.internal.tracking.MessageDirection;
import io.neonbee.internal.tracking.TrackingDataHandlingStrategy;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryContext;
import io.vertx.core.eventbus.Message;

public class TrackingInterceptor
implements Handler<DeliveryContext<Object>> {
    private final MessageDirection direction;
    private final TrackingDataHandlingStrategy handler;

    @VisibleForTesting
    public TrackingInterceptor(MessageDirection direction, TrackingDataHandlingStrategy handler) {
        this.direction = direction;
        this.handler = handler;
    }

    public void handle(DeliveryContext<Object> event) {
        Message message = event.message();
        String contextHeader = message.headers().get("context");
        if (contextHeader != null) {
            DataContext context = DataContextImpl.decodeContextFromString(contextHeader);
            if (message.replyAddress() != null) {
                switch (this.direction) {
                    case OUTBOUND: {
                        this.handler.handleOutBoundRequest(context);
                        break;
                    }
                    case INBOUND: {
                        this.handler.handleInBoundRequest(context);
                        break;
                    }
                }
            } else {
                switch (this.direction) {
                    case OUTBOUND: {
                        this.handler.handleOutBoundReply(context);
                        break;
                    }
                    case INBOUND: {
                        this.handler.handleInBoundReply(context);
                        break;
                    }
                }
            }
        }
        event.next();
    }

    public MessageDirection getDirection() {
        return this.direction;
    }

    public TrackingDataHandlingStrategy getHandler() {
        return this.handler;
    }
}

