/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import io.neonbee.NeonBeeDeployable;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataMap;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.data.DataVerticle;
import io.neonbee.entity.EntityVerticle;
import io.neonbee.entity.EntityWrapper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

@NeonBeeDeployable(namespace="neonbee", autoDeploy=false)
public class ConsolidationVerticle
extends DataVerticle<EntityWrapper> {
    public static final String ENTITY_TYPE_NAME_HEADER = "entityTypeName";
    private static final String NAME = "_consolidationVerticle";
    public static final String QUALIFIED_NAME = DataVerticle.createQualifiedName("neonbee", "_consolidationVerticle");

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Future<Collection<DataRequest>> requireData(DataQuery query, DataContext context) {
        return EntityVerticle.getVerticlesForEntityType(this.vertx, new FullQualifiedName(query.getHeader(ENTITY_TYPE_NAME_HEADER))).map(qualifiedNames -> qualifiedNames.stream().map(qualifiedName -> new DataRequest((String)qualifiedName, query)).collect(Collectors.toList()));
    }

    @Override
    public Future<EntityWrapper> retrieveData(DataQuery query, DataMap require, DataContext context) {
        FullQualifiedName entityTypeName = new FullQualifiedName(query.getHeader(ENTITY_TYPE_NAME_HEADER));
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (AsyncResult asyncResult : require.values()) {
            if (asyncResult.failed()) continue;
            Object object = asyncResult.result();
            if (!(object instanceof EntityWrapper)) {
                return Future.failedFuture((Throwable)new IllegalStateException("Entity verticle for consolidation are supposed to return entity wrappers"));
            }
            EntityWrapper entityWrapper = (EntityWrapper)object;
            if (!entityTypeName.equals((Object)entityWrapper.getTypeName())) {
                return Future.failedFuture((Throwable)new IllegalStateException("Cannot consolidate entities of different types into one entity collection"));
            }
            entities.addAll(entityWrapper.getEntities());
        }
        return Future.succeededFuture((Object)new EntityWrapper(entityTypeName, entities));
    }
}

