/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import io.neonbee.NeonBee;
import io.neonbee.internal.deploy.DeployableModule;
import io.neonbee.internal.deploy.Deployment;
import io.neonbee.internal.verticle.WatchVerticle;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class DeployerVerticle
extends WatchVerticle {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private final Map<Path, Deployment> deployedModules = new ConcurrentHashMap<Path, Deployment>();

    public DeployerVerticle(Path watchDir) {
        this(watchDir, 500L, TimeUnit.MILLISECONDS);
    }

    DeployerVerticle(Path watchDir, long interval, TimeUnit unit) {
        super(watchDir, interval, unit, false, true);
    }

    @Override
    public void observedCreate(Path affectedPath, Promise<Void> finishPromise) {
        if (!DeployerVerticle.isCopyLogic(this.config())) {
            this.triggerDeployment(affectedPath, finishPromise);
        } else {
            finishPromise.complete();
        }
    }

    @Override
    public void observedModify(Path affectedPath, Promise<Void> finishPromise) {
        if (DeployerVerticle.isCopyLogic(this.config())) {
            this.triggerDeployment(affectedPath, finishPromise);
        } else {
            finishPromise.complete();
        }
    }

    private void triggerDeployment(Path affectedPath, Promise<Void> finishPromise) {
        if (!affectedPath.toFile().getName().endsWith(".jar")) {
            finishPromise.complete();
            return;
        }
        DeployableModule.fromJar(this.vertx, affectedPath).compose(deployableModule -> deployableModule.deploy(NeonBee.get(this.vertx)).compose(deployment -> {
            Deployment replacedModule = this.deployedModules.put(affectedPath, (Deployment)deployment);
            if (Objects.isNull(replacedModule)) {
                return Future.succeededFuture();
            }
            return replacedModule.undeploy().onFailure(t -> LOGGER.error("Unexpected error occurred during undeploy of the replaced module", (Throwable)t));
        }).onFailure(throwable -> {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unexpected error occurred during deployment of module from JAR file: {}", affectedPath.toAbsolutePath(), throwable);
            }
        })).onComplete(finishPromise);
    }

    @Override
    public void observedDelete(Path affectedPath, Promise<Void> finishPromise) {
        if (!affectedPath.toFile().getName().endsWith(".jar")) {
            finishPromise.complete();
            return;
        }
        Deployment deployedModule = this.deployedModules.remove(affectedPath);
        if (deployedModule == null) {
            finishPromise.complete();
            return;
        }
        deployedModule.undeploy().onFailure(t -> LOGGER.error("Unexpected error occurred during undeploy", (Throwable)t)).onComplete(finishPromise);
    }
}

