/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import io.neonbee.NeonBee;
import io.neonbee.NeonBeeDeployable;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataVerticle;
import io.neonbee.internal.SharedDataAccessor;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.ext.healthchecks.CheckResult;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

@NeonBeeDeployable(namespace="neonbee", autoDeploy=false)
public class HealthCheckVerticle
extends DataVerticle<JsonArray> {
    public static final String SHARED_MAP_KEY = "healthCheckVerticles";
    private static final String NAME = "_healthCheckVerticle-" + UUID.randomUUID();
    public static final String QUALIFIED_NAME = DataVerticle.createQualifiedName("neonbee", NAME);
    private static final LoggingFacade LOGGER = LoggingFacade.create();

    @Override
    public void start(Promise<Void> promise) {
        Future.future(x$0 -> super.start((Promise<Void>)x$0)).compose(v -> {
            if (NeonBee.get(this.vertx).getOptions().isClustered()) {
                return this.register(this.vertx);
            }
            return Future.succeededFuture();
        }).onComplete(promise);
    }

    @Override
    public Future<JsonArray> retrieveData(DataQuery query, DataContext context) {
        List checkList = NeonBee.get(this.vertx).getHealthCheckRegistry().getHealthChecks().values().stream().map(hc -> hc.result().map(CheckResult::toJson)).collect(Collectors.toList());
        return AsyncHelper.allComposite(checkList).map(v -> new JsonArray(checkList.stream().map(Future::result).peek(r -> r.remove("outcome")).collect(Collectors.toList())));
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Future<Void> register(Vertx vertx) {
        AsyncMap<String, Object> sharedMap = NeonBee.get(vertx).getAsyncMap();
        return new SharedDataAccessor(vertx, HealthCheckVerticle.class).getLock(SHARED_MAP_KEY).onFailure(throwable -> LOGGER.error("Error acquiring lock with name {}", SHARED_MAP_KEY, throwable)).compose(lock -> sharedMap.get((Object)SHARED_MAP_KEY).compose(qualifiedNamesOrNull -> {
            JsonArray qualifiedNames;
            String qualifiedName = this.getQualifiedName();
            JsonArray jsonArray = qualifiedNames = qualifiedNamesOrNull != null ? (JsonArray)qualifiedNamesOrNull : new JsonArray();
            if (!qualifiedNames.contains((Object)qualifiedName)) {
                qualifiedNames.add((Object)qualifiedName);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Register health check verticle {} of node {}.", qualifiedName, NeonBee.get(vertx).getNodeId());
            }
            return sharedMap.put((Object)SHARED_MAP_KEY, (Object)qualifiedNames);
        }).onComplete(anyResult -> {
            LOGGER.debug("Releasing lock {}", SHARED_MAP_KEY);
            lock.release();
        }));
    }
}

